/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenAbout;
import sk.inlogic.screen.ScreenInstructions;
import sk.inlogic.screen.ScreenRealyQuit;
import sk.inlogic.screen.ScreenSelectPack;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private MainCanvas _mainCanvas;
    public static final int COMP_ID_PLAY = 0;
    public static final int COMP_ID_INSTRUCTIONS = 1;
    public static final int COMP_ID_ABOUT = 2;
    public static final int COMP_ID_SOUND = 3;
    public static final int COMP_ID_SETTINGS = 4;
    public static final int COMP_ID_QUIT = 5;
    public static final int COMP_ID_NONE = 6;
    private static final int TOTAL_COMP_IDS = 7;
    private final int _iNextScreenPack;
    private final int _iNextScreenInst;
    private final int _iNextScreenAbou;
    private final int _iNextScreenQuit;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iSelectedCompId;
    private int _iSelectorCompId;
    private int _iOffsetButton = 0;
    private int _iOffsetY;
    private int _iTmpSlctdCmpId;
    private int _interuption = 0;
    private int _iCycle = 10;
    private int _iMusicControler = 0;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int sel;
    private int force;
    private boolean _bCheck = false;
    private boolean _bChangeSequence = false;
    private boolean _bReleasedTouch = false;
    private boolean _bActiveButton = true;
    private Rectangle[] _rectItems = new Rectangle[7];
    private Rectangle _rectLogo;
    private AnimationComponent[] _animationComponents = new AnimationComponent[7];
    private Image _imgBg;
    private Image _imgGameLogo;
    private Sprite _sprButtonBar;
    private Sprite _sprButtonIcons;
    private Sprite _sprButtonIconsSelector;
    private Sprite _sprFkIcons;
    private PreparedText _ptItemName;

    public ScreenMenu(MainCanvas mC, int selectedItem) {
        this._iNextScreenPack = 0;
        this._iNextScreenInst = 1;
        this._iNextScreenAbou = 2;
        this._iNextScreenQuit = 3;
        MainCanvas.counterX = 0;
        MainCanvas.counterY = 0;
        MainCanvas.slcPack = 0;
        this._mainCanvas = mC;
        this._iSelectedCompId = 6;
        this._iSelectorCompId = 6;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.calculatePositions();
        this.preapreTxt();
        this.initAnimationComponents();
        this.startAnimation(true, -1);
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 4});
        Resources.loadSprites(new int[]{1, 5, 20, 0});
        Resources.loadGFont(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 4});
        Resources.freeSprites(new int[]{1, 5, 20, 0});
        Resources.freeGFont(0);
    }

    private void initDimensions() {
        this._WIDTH = this._mainCanvas.getWidth();
        this._HEIGHT = this._mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this._imgGameLogo = Resources.resImgs[4];
    }

    private void initSprites() {
        this._sprButtonBar = Resources.resSprs[5];
        this._sprButtonIcons = Resources.resSprs[1];
        this._sprButtonIconsSelector = Resources.resSprs[20];
        this._sprFkIcons = Resources.resSprs[0];
    }

    private void initFonts() {
        this._ptItemName = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this._mainCanvas, this._rectLogo, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this._mainCanvas, this._rectItems[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this._mainCanvas, this._rectItems[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this._mainCanvas, this._rectItems[2], this._WIDTH, this._HEIGHT);
        this._animationComponents[4] = new AnimationComponent(this._mainCanvas, this._rectItems[3], this._WIDTH, this._HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this._mainCanvas, this._rectItems[5], this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(1);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(0);
        this._animationComponents[5].startHideAnimation(1);
    }

    private void preapreTxt() {
        this._ptItemName.prepareText("PLAY", this._rectItems[0].width);
    }

    private void freeGraphics() {
        this._imgBg = null;
        this._imgGameLogo = null;
        this._sprButtonIconsSelector = null;
        this._sprButtonBar = null;
        this._sprButtonIcons = null;
        this._sprFkIcons = null;
        this._ptItemName = null;
    }

    public void beforeInteruption() {
        this._bCheck = this._mainCanvas.getSoundManager().IsSoundOn();
        this._mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
    }

    private void calculatePositions() {
        int itemHeight = this._sprButtonIcons.getHeight();
        int itemWidth = this._sprButtonIcons.getWidth();
        int fkHeight = this._sprButtonIcons.getHeight();
        int posX = 0;
        int _iOffsetY = this._HEIGHT - (this._imgGameLogo.getWidth() << 1);
        int _iTmpPosY = this._HEIGHT - _iOffsetY - this._imgGameLogo.getWidth();
        this._rectLogo = new Rectangle(this._WIDTH >> 1, _iTmpPosY >> 1, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        int posY = this._rectLogo.y + this._rectLogo.height + (_iOffsetY >>= 3);
        posX = (this._WIDTH >> 1) - (this._sprButtonIcons.getWidth() >> 1);
        this._rectItems[0] = new Rectangle(posX, posY, itemWidth, itemHeight);
        this._rectItems[1] = new Rectangle(posX, posY += itemHeight + _iOffsetY, itemWidth, itemHeight);
        this._rectItems[2] = new Rectangle(posX, posY += itemHeight + _iOffsetY, itemWidth, itemHeight);
        this._rectItems[3] = new Rectangle(posX, posY += itemHeight + _iOffsetY, itemWidth, itemHeight);
        this._rectItems[4] = new Rectangle(0, MainCanvas.HEIGHT - fkHeight, itemWidth + (itemWidth >> 1), fkHeight);
        this._rectItems[5] = new Rectangle(MainCanvas.WIDTH - (this._sprFkIcons.getWidth() << 1), MainCanvas.HEIGHT - (this._sprFkIcons.getHeight() << 1), this._sprFkIcons.getWidth() << 1, this._sprFkIcons.getHeight() << 1);
        _iOffsetY = (this._sprButtonBar.getHeight() >> 1) - (this._sprButtonBar.getHeight() >> 1);
    }

    public void update(long lastRunLenght) {
        this.updateSoundInterupt();
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void updateSoundInterupt() {
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this._mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _iNextScreen) {
        switch (_iNextScreen) {
            case 0: {
                this._mainCanvas.changeLastActiveScreen(new ScreenSelectPack(this._mainCanvas, 0));
                break;
            }
            case 1: {
                this._mainCanvas.changeLastActiveScreen(new ScreenInstructions(this._mainCanvas));
                break;
            }
            case 2: {
                this._mainCanvas.changeLastActiveScreen(new ScreenAbout(this._mainCanvas));
                break;
            }
            case 3: {
                this._mainCanvas.changeLastActiveScreen(new ScreenRealyQuit(this._mainCanvas, this._iSelectorCompId));
            }
        }
        this._mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintDialog(g);
        this.paintLogo(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
    }

    private void paintLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this._rectLogo.x, this._rectLogo.y, 3);
    }

    private void paintDialog(Graphics g) {
        if (this._iSelectorCompId == 0) {
            this.paintButton(g, 0, true);
        } else {
            this.paintButton(g, 0, false);
        }
        if (this._iSelectorCompId == 1) {
            this.paintButton(g, 1, true);
        } else {
            this.paintButton(g, 1, false);
        }
        if (this._iSelectorCompId == 2) {
            this.paintButton(g, 2, true);
        } else {
            this.paintButton(g, 2, false);
        }
    }

    private void paintButton(Graphics g, int _iDx, boolean _bSelected) {
        switch (_iDx) {
            case 2: {
                this._sprButtonIcons.setFrame(2);
                break;
            }
            case 1: {
                this._sprButtonIcons.setFrame(0);
                break;
            }
            case 0: {
                this._sprButtonIcons.setFrame(3);
                break;
            }
            case 3: {
                this._sprButtonIcons.setFrame(this._mainCanvas.getSoundManager().IsSoundOn() ? 4 : 5);
            }
        }
        this._sprButtonIcons.setPosition(this._iOffsetButton + this._rectItems[_iDx].x + (this._sprButtonBar.getWidth() >> 1) + (this._sprButtonBar.getWidth() >> 1) - (this._sprButtonIcons.getWidth() >> 1), this._rectItems[_iDx].y);
        this._sprButtonIcons.paint(g);
        if (_bSelected) {
            this._sprButtonIconsSelector.setPosition(this._iOffsetButton + this._rectItems[_iDx].x + (this._sprButtonBar.getWidth() >> 1) + (this._sprButtonBar.getWidth() >> 1) - (this._sprButtonIcons.getWidth() >> 1), this._rectItems[_iDx].y);
            this._sprButtonIconsSelector.paint(g);
        }
    }

    private void paintButtonsTxt(Graphics g) {
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(21), this._rectItems[0].width);
        this._ptItemName.drawText(g, this._rectItems[0], this._ptItemName.getTextHeight() >> 2, 3);
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(22), this._rectItems[1].width);
        this._ptItemName.drawText(g, this._rectItems[1], this._ptItemName.getTextHeight() >> 2, 3);
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(23), this._rectItems[1].width);
        this._ptItemName.drawText(g, this._rectItems[2], this._ptItemName.getTextHeight() >> 2, 3);
        if (this._mainCanvas.getSoundManager().IsSoundOn()) {
            this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(26), this._rectItems[1].width);
        } else {
            this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(27), this._rectItems[1].width);
        }
        this._ptItemName.drawText(g, this._rectItems[3], this._ptItemName.getTextHeight() >> 2, 3);
    }

    private void paintFK(Graphics g) {
        this._sprFkIcons.setFrame(6);
        this._sprFkIcons.setPosition(this._rectItems[5].x + this._sprFkIcons.getWidth(), this._rectItems[5].y + this._sprFkIcons.getHeight());
        this._sprFkIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        this._iTmpSlctdCmpId = keyCode;
        if (this._bActiveButton) {
            if (Keys.isFKLeftCode(keyCode)) {
                switch (this._iSelectedCompId) {
                    case 0: {
                        this.startAnimation(true, 0);
                        break;
                    }
                    case 1: {
                        this.startAnimation(true, 1);
                        break;
                    }
                    case 2: {
                        this.startAnimation(true, 2);
                        break;
                    }
                }
            } else if (Keys.isFKRightCode(keyCode)) {
                this.startAnimation(true, 3);
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    switch (this._iSelectedCompId) {
                        case 0: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 2;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            Keys.keyReleased(keyCode);
                            this._bReleasedTouch = true;
                            this.startAnimation(true, 0);
                            break;
                        }
                        case 1: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 2;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this._bReleasedTouch = true;
                            this.startAnimation(true, 1);
                            break;
                        }
                        case 2: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this._bReleasedTouch = true;
                            this.startAnimation(true, 2);
                            break;
                        }
                        case 3: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 2;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this._bReleasedTouch = true;
                            if (this._mainCanvas.getSoundManager().IsSoundOn()) {
                                this._mainCanvas.getSoundManager().SetSoundOn(false);
                                this._mainCanvas.getSoundManager().Stop();
                                break;
                            }
                            this._mainCanvas.getSoundManager().SetSoundOn(true);
                            this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                        }
                    }
                }
                this._iSelectorCompId = this._iSelectedCompId;
                this._iTmpSlctdCmpId = this._iSelectedCompId;
                this.force = this._iSelectedCompId;
            }
            this._mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (i == 6) {
                this._iSelectorCompId = this._iSelectedCompId = 6;
                this._mainCanvas.repaint();
                break;
            }
            if (i == 6 || !this._rectItems[i].contains(x, y)) continue;
            this.sel = i <= 4 ? i : this.sel;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 4: {
                    break;
                }
                case 5: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    this._iSelectorCompId = i;
                    this._iTmpSlctdCmpId = this._iSelectedCompId;
                    Keys.keyPressed(53);
                    this._mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this._iSelectedCompId != 6) {
            if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
                switch (this._iSelectedCompId) {
                    case 4: {
                        break;
                    }
                    case 5: {
                        Keys.keyReleased(-7);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this._iSelectorCompId = this._iSelectedCompId = 6;
            this._mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._iSelectedCompId != 6) {
            switch (this._iSelectedCompId) {
                case 5: {
                    this._mainCanvas.changeLastActiveScreen(new ScreenRealyQuit(this._mainCanvas, this._iSelectorCompId));
                    if (!Keys.isKeyPressed(-7)) break;
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    this._bActiveButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        this._iSelectorCompId = this._iSelectedCompId = 6;
        this._mainCanvas.repaint();
    }
}

