/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.util;

import javax.microedition.lcdui.Canvas;
import sk.inlogic.util.ArrayInt;

public class Keys {
    public static Canvas canvas;
    private static final int MAX_PRESSED_KEYS = 2;
    private static final int MAX_PRESSED_ACTIONS = 4;
    public static final int ACTION_NULL = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_DOWN = 2;
    public static final int ACTION_LEFT = 3;
    public static final int ACTION_RIGHT = 4;
    public static final int ACTION_FIRE = 5;
    private static int[] allPressedActions;
    public static final int KEY_NULL = -9999;
    public static final int KEY_NUM0_CODE = 48;
    public static final int KEY_NUM1_CODE = 49;
    public static final int KEY_NUM2_CODE = 50;
    public static final int KEY_NUM3_CODE = 51;
    public static final int KEY_NUM4_CODE = 52;
    public static final int KEY_NUM5_CODE = 53;
    public static final int KEY_NUM6_CODE = 54;
    public static final int KEY_NUM7_CODE = 55;
    public static final int KEY_NUM8_CODE = 56;
    public static final int KEY_NUM9_CODE = 57;
    public static final int FK_LEFT_CODE = -6;
    public static final int FK_RIGHT_CODE = -7;
    public static final int FK_CLEAR_CODE = -16;
    public static final int FK_BACK_CODE = -9999;
    public static final int FK_ENTER_CODE = -9999;
    private static int[] allPressedKeys;

    public static void resetAllPressedKeysAndActions() {
        ArrayInt.resetArray(allPressedKeys);
        ArrayInt.resetArray(allPressedActions);
    }

    public static void keyPressed(int keyCode) {
        Keys.addPressedKey(keyCode);
        Keys.addActionsByPressedKey(keyCode);
    }

    public static void keyReleased(int keyCode) {
        Keys.removeReleasedKey(keyCode);
        Keys.actualizeAllPressedActions();
    }

    public static boolean isKeyPressed(int keyCode) {
        return ArrayInt.existValue(allPressedKeys, keyCode);
    }

    public static boolean isActionPressed(int actionType) {
        return ArrayInt.existValue(allPressedActions, actionType);
    }

    public static boolean isFKLeftCode(int keyCode) {
        return Math.abs(keyCode) == Math.abs(-6);
    }

    public static boolean isFKRightCode(int keyCode) {
        return Math.abs(keyCode) == Math.abs(-7);
    }

    public static boolean isActionGeneratedByKey(int actionType, int keyCode) {
        int gameAction = -9999;
        if (!Keys.isFKLeftCode(keyCode) && !Keys.isFKRightCode(keyCode)) {
            gameAction = canvas.getGameAction(keyCode);
        }
        switch (actionType) {
            case 1: {
                return keyCode == 49 || keyCode == 50 || keyCode == 51 || gameAction == 1;
            }
            case 2: {
                return keyCode == 55 || keyCode == 56 || keyCode == 57 || gameAction == 6;
            }
            case 3: {
                return keyCode == 49 || keyCode == 52 || keyCode == 55 || gameAction == 2;
            }
            case 4: {
                return keyCode == 51 || keyCode == 54 || keyCode == 57 || gameAction == 5;
            }
            case 5: {
                return keyCode == 53 || gameAction == 8;
            }
        }
        return false;
    }

    private static void addPressedKey(int keyCode) {
        ArrayInt.addValue(allPressedKeys, keyCode);
    }

    private static void removeReleasedKey(int keyCode) {
        ArrayInt.removeValue(allPressedKeys, keyCode);
    }

    private static void addActionsByPressedKey(int keyCode) {
        if (Keys.isActionGeneratedByKey(1, keyCode)) {
            ArrayInt.addUniqueValue(allPressedActions, 1);
        }
        if (Keys.isActionGeneratedByKey(2, keyCode)) {
            ArrayInt.addUniqueValue(allPressedActions, 2);
        }
        if (Keys.isActionGeneratedByKey(3, keyCode)) {
            ArrayInt.addUniqueValue(allPressedActions, 3);
        }
        if (Keys.isActionGeneratedByKey(4, keyCode)) {
            ArrayInt.addUniqueValue(allPressedActions, 4);
        }
        if (Keys.isActionGeneratedByKey(5, keyCode)) {
            ArrayInt.addUniqueValue(allPressedActions, 5);
        }
    }

    private static void actualizeAllPressedActions() {
        ArrayInt.resetArray(allPressedActions);
        for (int i = 0; i < allPressedKeys.length; ++i) {
            if (allPressedKeys[i] == -9999999) continue;
            Keys.addActionsByPressedKey(allPressedKeys[i]);
        }
    }

    static {
        allPressedActions = new int[4];
        allPressedKeys = new int[2];
    }
}

