/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenRealyQuit
implements IScreen {
    private MainCanvas mainCanvas;
    private static final int COMP_ID_YES = 0;
    private static final int COMP_ID_NO = 1;
    private static final int TOTAL_COMP_IDS = 2;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int interuption = 0;
    private int _iSelectedCompId;
    private int _iSelectedComMenuId;
    private int _iCycle = 10;
    private int _iFinalHeight;
    private int _totalRowTiles = 0;
    private int _totalColTiles = 0;
    private int _iOffsetX;
    private int _iOffsetXDefault = 5;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int[] _animationSequence = new int[4];
    private boolean _bChangeSequence = false;
    private Rectangle[] _rectItems = new Rectangle[2];
    private Rectangle _rectDialog;
    private Rectangle _rectTop;
    private Image _imgBg;
    private Sprite _sprFkButton;
    private Sprite _sprFkIcons;
    private Sprite _sprWindows;
    private PreparedText _ptQuit;
    private PreparedText _ptTitle;
    private AnimationComponent[] _animationComponents = new AnimationComponent[4];

    public ScreenRealyQuit(MainCanvas mC, int selectedItem) {
        this.mainCanvas = mC;
        this._iSelectedComMenuId = selectedItem;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initSprites();
        this.initImages();
        this.initFonts();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2});
        Resources.loadSprites(new int[]{1, 0, 10});
        Resources.loadGFont(0);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2});
        Resources.freeSprites(new int[]{1, 0, 10});
        Resources.freeGFont(0);
    }

    private void initDimensions() {
        this._WIDTH = this.mainCanvas.getWidth();
        this._HEIGHT = this.mainCanvas.getHeight();
    }

    private void initSprites() {
        this._sprFkButton = Resources.resSprs[1];
        this._sprFkIcons = Resources.resSprs[0];
        this._sprWindows = Resources.resSprs[10];
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
    }

    private void initFonts() {
        this._ptQuit = new PreparedText(Resources.resGFonts[0]);
        this._ptTitle = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
        this._animationSequence[3] = 3;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this._rectDialog, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this._rectItems[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this._rectItems[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(0);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(0);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(1);
        this._animationComponents[3].startHideAnimation(0);
    }

    private void prepareTxt() {
        this._ptQuit.prepareText(Resources.resTexts[0].getHashedString(2), this._rectDialog.width);
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(2), this._rectDialog.width);
    }

    private void freeGraphics() {
        this._imgBg = null;
        this._sprFkButton = null;
        this._sprFkIcons = null;
        this._sprWindows = null;
    }

    private void calculatePositions() {
        this._rectTop = new Rectangle(this._iOffsetXDefault, this._sprFkIcons.getHeight() - this._sprFkIcons.getHeight(), this._WIDTH - (this._iOffsetXDefault << 1), this._sprFkIcons.getHeight());
        int _windowWidth = this._WIDTH >> 1;
        int _offsetX = _windowWidth % this._sprWindows.getWidth() > 0 ? _windowWidth % this._sprWindows.getWidth() : this._sprWindows.getWidth();
        int _offsetTopY = (this._sprFkIcons.getHeight() - this._sprFkIcons.getHeight() << 1) + this._sprFkIcons.getHeight();
        int _offsetBottomY = this._sprFkIcons.getHeight() + (this._sprFkIcons.getHeight() - this._sprFkIcons.getHeight());
        int _panelHeight = this._HEIGHT - _offsetTopY - _offsetBottomY;
        this._iOffsetX = _offsetX;
        this._iFinalHeight = _panelHeight % this._sprWindows.getWidth() == 0 ? _panelHeight : _panelHeight - _panelHeight % this._sprWindows.getWidth();
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, this._WIDTH - (_offsetX << 1), this._iFinalHeight);
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, this._WIDTH - (_offsetX << 1), this._iFinalHeight);
        this._rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - (this._sprFkButton.getWidth() << 1), this._sprFkButton.getWidth() << 1, this._sprFkButton.getHeight() << 1);
        this._rectItems[1] = new Rectangle(MainCanvas.WIDTH - (this._sprFkButton.getWidth() << 1), MainCanvas.HEIGHT - (this._sprFkButton.getHeight() << 1), this._sprFkButton.getWidth() << 1, this._sprFkButton.getHeight() << 1);
        this.calculateWindowTiles();
    }

    private void calculateWindowTiles() {
        this._totalColTiles = this._rectDialog.width / this._sprWindows.getWidth();
        this._totalRowTiles = this._rectDialog.height / this._sprWindows.getWidth();
    }

    public void beforeInteruption() {
        this.mainCanvas.getSoundManager().Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && this.mainCanvas.getSoundManager().IsSoundOn()) {
            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void update(long lastRunLenght) {
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintBody(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintBody(Graphics g) {
        this.paintWindow(g);
        this.paintQuit(g);
    }

    private void paintTitle(Graphics g) {
        this._ptTitle.drawText(g, this._rectTop, this._ptTitle.getTextHeight() >> 2, 3);
    }

    private void paintWindow(Graphics g) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int x = this._rectDialog.x; x < this._rectDialog.x + this._rectDialog.width; x += this._sprWindows.getWidth()) {
            for (int y = this._rectDialog.y; y < this._rectDialog.y + this._rectDialog.height; y += this._sprWindows.getWidth()) {
                this._sprWindows.setFrame(this.getWindowTileSprite(_actualTileX, _actualTileY));
                this._sprWindows.setPosition(x, y);
                this._sprWindows.paint(g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private void paintQuit(Graphics g) {
        this._ptQuit.drawText(g, this._rectDialog, this._ptQuit.getTextHeight() >> 1, 3);
    }

    private void paintFK(Graphics g) {
        this._sprFkButton.setFrame(0);
        this._sprFkButton.setPosition(this._rectItems[1].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1) + this._sprFkButton.getWidth(), this._rectItems[1].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
        this._sprFkButton.paint(g);
        this._sprFkIcons.setFrame(2);
        this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
        this._sprFkIcons.paint(g);
        this._sprFkButton.setFrame(0);
        this._sprFkButton.setPosition(this._rectItems[0].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1), this._rectItems[0].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
        this._sprFkButton.paint(g);
        this._sprFkIcons.setFrame(1);
        this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
        this._sprFkIcons.paint(g);
    }

    private int getWindowTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._totalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._totalColTiles - 1) {
            return 2;
        }
        if (_y == this._totalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._totalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._totalColTiles - 1 && _y < this._totalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._totalRowTiles - 1 && _x < this._totalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._totalRowTiles - 1 && _x == this._totalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    public void keyPressed(int keyCode) {
        if (this.interuption == 1) {
            this.interuption = 0;
            this.afterInteruption();
        }
    }

    public void keyReleased(int keyCode) {
        if (Keys.isFKLeftCode(keyCode)) {
            X.quitApp();
        } else if (Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
        }
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyPressed(-6);
                    break;
                }
                case 1: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    Keys.keyPressed(53);
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-6);
                    break;
                }
                case 1: {
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
            this.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this._iSelectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 1: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

