/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.screen.ScreenSelectBonusLevel;
import sk.inlogic.screen.ScreenSelectLevel;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSelectPack
implements IScreen {
    private MainCanvas mainCanvas;
    public static final int COMP_ID_CLASSIC = 0;
    public static final int COMP_ID_BONUS = 1;
    private static final int COMP_ID_SETTINGS = 2;
    private static final int COMP_ID_BACK = 3;
    public static final int COMP_ID_NONE = 4;
    private static final int TOTAL_COMP_IDS = 5;
    private final int _iNextScreenClasic;
    private final int _iNextScreenBonus;
    private final int _iNextScreenMenu;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iSelectedCompId;
    private int _iSelectorCompId;
    private int _iOffsetButton = 5;
    private int _iOffsetY;
    private int _iCycle = 10;
    private int interuption = 0;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int _iScoresCount = 0;
    private int _iCount = 0;
    private boolean _bChangeSequence = false;
    private boolean _bCheck = false;
    private boolean _bBonusIsLocked = true;
    private boolean _bActiveButton = true;
    private String[] _sLevelStars = new String[60];
    private Rectangle[] _rectItems = new Rectangle[5];
    private Rectangle _rectLogo;
    private Image _imgBg;
    private Image _imgGameLogo;
    private Sprite _sprButtonBar;
    private Sprite _sprButtonSelector;
    private Sprite _sprFkIcons;
    private PreparedText _ptItemName;
    private AnimationComponent[] _animationComponents = new AnimationComponent[7];
    int a;
    private boolean releasedTouch = false;
    private int sel = this._iSelectedCompId;
    private int s = this._iSelectedCompId;

    public ScreenSelectPack(MainCanvas mC, int selectedItem) {
        this._iNextScreenClasic = 0;
        this._iNextScreenBonus = 1;
        this._iNextScreenMenu = 2;
        MainCanvas.counterX = 0;
        MainCanvas.counterY = 0;
        MainCanvas.slcPack = 0;
        MainCanvas.slcLvl = 0;
        this.mainCanvas = mC;
        this._iSelectedCompId = selectedItem;
        this._iSelectorCompId = selectedItem;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.calculatePositions();
        this.preapreTxt();
        this.initAnimationComponents();
        this.startAnimation(true, -1);
        this.initLocalScore();
        this.unlockBonusPack();
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 4});
        Resources.loadSprites(new int[]{2, 0, 7});
        Resources.loadGFont(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 4});
        Resources.freeSprites(new int[]{2, 0, 7});
        Resources.freeGFont(0);
    }

    private void initLocalScore() {
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
    }

    private void initDimensions() {
        this._WIDTH = this.mainCanvas.getWidth();
        this._HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this._imgGameLogo = Resources.resImgs[4];
    }

    private void initSprites() {
        this._sprButtonSelector = Resources.resSprs[7];
        this._sprFkIcons = Resources.resSprs[0];
    }

    private void initFonts() {
        this._ptItemName = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectLogo, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this._rectItems[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this._rectItems[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this._rectItems[3], this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(1);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
    }

    private void preapreTxt() {
        this._ptItemName.prepareText("PLAY", this._rectItems[0].width);
        this._ptItemName = new PreparedText(Resources.resGFonts[0]);
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(70), this._rectItems[0].width);
    }

    private void freeGraphics() {
        this._imgBg = null;
        this._imgGameLogo = null;
        this._sprButtonBar = null;
        this._sprButtonSelector = null;
        this._sprFkIcons = null;
        this._ptItemName = null;
    }

    public void beforeInteruption() {
        this._bCheck = this.mainCanvas.getSoundManager().IsSoundOn();
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        int itemHeight = this._sprButtonBar.getHeight();
        int itemWidth = this._sprButtonBar.getWidth();
        int fkHeight = this._sprFkIcons.getHeight();
        int posX = 0;
        int _iOffsetY = this._HEIGHT - (this._imgGameLogo.getWidth() << 1);
        int _iTmpPosY = this._HEIGHT - _iOffsetY - this._imgGameLogo.getWidth();
        this._rectLogo = new Rectangle(this._WIDTH >> 1, _iTmpPosY >> 1, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        _iOffsetY = this._HEIGHT - this._imgGameLogo.getWidth() - this._sprButtonBar.getWidth();
        int posY = this._imgGameLogo.getHeight() + itemHeight + ((_iOffsetY >>= 3) << 1);
        this._rectItems[0] = new Rectangle(posX, posY, this.mainCanvas.getWidth(), itemHeight);
        this._rectItems[1] = new Rectangle(posX, posY += itemHeight + _iOffsetY, this.mainCanvas.getWidth(), itemHeight);
        this._rectItems[3] = new Rectangle(MainCanvas.WIDTH - (this._sprFkIcons.getWidth() << 1), MainCanvas.HEIGHT - (this._sprFkIcons.getHeight() << 1), this._sprFkIcons.getWidth() << 1, this._sprFkIcons.getHeight() << 1);
        _iOffsetY = (this._sprButtonBar.getHeight() >> 1) - (this._sprButtonBar.getHeight() >> 1);
    }

    private void unlockBonusPack() {
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        if (scores != null) {
            this._iScoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        for (int i = 0; i < 60; ++i) {
            if (i < this._iScoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this._sLevelStars[i] = Integer.toString(scoreItem.scoreValue);
                ++this._iCount;
                continue;
            }
            this._sLevelStars[i] = null;
        }
        if (this._sLevelStars[this._sLevelStars.length - 1] != null) {
            this._sLevelStars[this._sLevelStars.length - 1] = Integer.toString(scoreItem.scoreValue);
            this._bBonusIsLocked = this._sLevelStars[this._sLevelStars.length - 1].equals("");
        }
    }

    public void update(long lastRunLenght) {
        this._bActiveButton = true;
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _iNextScreen) {
        switch (_iNextScreen) {
            case 0: {
                this.mainCanvas.changeLastActiveScreen(new ScreenSelectLevel(this.mainCanvas, 0));
                break;
            }
            case 1: {
                this.mainCanvas.changeLastActiveScreen(new ScreenSelectBonusLevel(this.mainCanvas, 0));
                break;
            }
            case 2: {
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
            }
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintDialog(g);
        this.paintLogo(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this._rectLogo.x, this._rectLogo.y, 17);
    }

    private void paintDialog(Graphics g) {
        if (this._iSelectorCompId == 0) {
            this.paintButton(g, 0, true);
        } else {
            this.paintButton(g, 0, false);
        }
        if (this._iSelectorCompId == 1) {
            this.paintButton(g, 1, true);
        } else {
            this.paintButton(g, 1, false);
        }
        this.paintButtonsTxt(g);
    }

    private void paintButton(Graphics g, int _iDx, boolean _bSelected) {
        if (_iDx == 1) {
            if (!this._bBonusIsLocked) {
                this._sprButtonBar.setFrame(1);
                this._sprButtonBar.setPosition(this._iOffsetButton + this._rectItems[_iDx].x + (this._sprButtonBar.getWidth() >> 1), this._rectItems[_iDx].y + (this._sprButtonBar.getHeight() - this._sprButtonBar.getHeight() >> 1));
                this._sprButtonBar.paint(g);
            } else {
                this._sprButtonBar.setFrame(0);
                this._sprButtonBar.setPosition(this._iOffsetButton + this._rectItems[_iDx].x + (this._sprButtonBar.getWidth() >> 1), this._rectItems[_iDx].y + (this._sprButtonBar.getHeight() - this._sprButtonBar.getHeight() >> 1));
                this._sprButtonBar.paint(g);
            }
        } else {
            this._sprButtonBar.setFrame(1);
            this._sprButtonBar.setPosition(this._iOffsetButton + this._rectItems[_iDx].x + (this._sprButtonBar.getWidth() >> 1), this._rectItems[_iDx].y + (this._sprButtonBar.getHeight() - this._sprButtonBar.getHeight() >> 1));
            this._sprButtonBar.paint(g);
        }
        if (_bSelected) {
            this._sprButtonSelector.setFrame(0);
            this._sprButtonSelector.setPosition(this._iOffsetButton + this._rectItems[_iDx].x + (this._sprButtonSelector.getWidth() >> 1), this._rectItems[_iDx].y + (this._sprButtonSelector.getHeight() - this._sprButtonSelector.getHeight() >> 1));
            this._sprButtonSelector.paint(g);
        }
    }

    private void paintButtonsTxt(Graphics g) {
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(70), this._rectItems[0].width);
        this._ptItemName.drawText(g, this._rectItems[0], this._ptItemName.getTextHeight() >> 2, 3);
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(71), this._rectItems[1].width);
        this._ptItemName.drawText(g, this._rectItems[1], this._ptItemName.getTextHeight() >> 2, 3);
    }

    private void paintFK(Graphics g) {
        this._sprFkIcons.setFrame(5);
        this._sprFkIcons.setPosition(this._rectItems[3].x + (this._sprFkIcons.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1) + this._sprFkIcons.getWidth(), this._rectItems[3].y + (this._sprFkIcons.getHeight() >> 1) - (this._sprFkIcons.getHeight() >> 1) + this._sprFkIcons.getWidth());
        this._sprFkIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (this._bActiveButton) {
            if (Keys.isFKLeftCode(keyCode)) {
                switch (this._iSelectedCompId) {
                    case 0: {
                        this.startAnimation(true, 0);
                        break;
                    }
                    case 1: {
                        if (this._bBonusIsLocked) break;
                        this.startAnimation(true, 1);
                    }
                }
            } else if (Keys.isFKRightCode(keyCode)) {
                this.startAnimation(true, 2);
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    switch (this._iSelectedCompId) {
                        case 0: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this.startAnimation(true, 0);
                            break;
                        }
                        case 1: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode) || this._bBonusIsLocked) break;
                            this.startAnimation(true, 1);
                        }
                    }
                }
                this._iSelectorCompId = this._iSelectedCompId;
                this.a = this._iSelectedCompId;
            }
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        if (this._iSequenceShow == this._iSequence) {
            return;
        }
        if (this._iSequenceHide == this._iSequence) {
            return;
        }
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (i == 4) {
                this._iSelectorCompId = this._iSelectedCompId = 4;
                this.mainCanvas.repaint();
                break;
            }
            if (i == 4 || this._rectItems[i] == null || !this._rectItems[i].contains(x, y)) continue;
            this.sel = i <= 4 ? i : this.sel;
            this._iSelectedCompId = i;
            this.s = i;
            switch (this._iSelectedCompId) {
                case 2: {
                    Keys.keyPressed(4098);
                    break;
                }
                case 3: {
                    Keys.keyPressed(27);
                    break;
                }
                default: {
                    this._iSelectorCompId = i;
                    this.a = this._iSelectedCompId;
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this._iSelectedCompId != 4) {
            if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
                switch (this._iSelectedCompId) {
                    case 2: {
                        Keys.keyReleased(4098);
                        break;
                    }
                    case 3: {
                        Keys.keyReleased(27);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this._iSelectorCompId = this._iSelectedCompId = 4;
            this.mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._iSequenceShow == this._iSequence) {
            return;
        }
        if (this._iSequenceHide == this._iSequence) {
            return;
        }
        if (this._iSelectedCompId != 4) {
            switch (this._iSelectedCompId) {
                case 3: {
                    this.startAnimation(true, 2);
                    if (!Keys.isKeyPressed(27)) break;
                    this.keyReleased(27);
                    Keys.keyReleased(27);
                    break;
                }
                default: {
                    this._bActiveButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        this._iSelectorCompId = this._iSelectedCompId = 4;
        this.mainCanvas.repaint();
    }
}

