/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Common;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    private static String langDir = "/";
    public static final int _IMG_RES_ROTATION = 0;
    public static final int _IMG_SPLASH = 1;
    public static final int _IMG_BG = 2;
    public static final int _IMG_CORP_LOGO = 3;
    public static final int _IMG_GAME_LOGO = 4;
    public static final int _IMG_GAME_TILE = 5;
    public static final int _IMG_GAME_TILE_DECOR = 6;
    public static final int _IMG_LVL_STAR = 7;
    public static final int _IMG_LANGUAGE_SELECTOR = 8;
    public static final int TOTAL_IMGS = 9;
    public static Image[] resImgs = new Image[9];
    public static final int _SPR_FK_ICONS = 0;
    public static final int _SPR_FK_BUTTON = 1;
    public static final int _SPR_MENU_ICONS = 2;
    public static final int _SPR_MENU_BUTTON = 3;
    public static final int _SPR_PLAY_ICON = 4;
    public static final int _SPR_PLAY_BUTTON = 5;
    public static final int _SPR_BUTTON_LOCK = 6;
    public static final int _SPR_LEVEL_SELECTOR = 7;
    public static final int _SPR_TWISTER_DECOR = 8;
    public static final int _SPR_LEVEL_STAR = 9;
    public static final int _SPR_WINDOW = 10;
    public static final int _SPR_GAME_ICONS = 11;
    public static final int _SPR_GAME_PROGRESS_BAR = 12;
    public static final int _SPR_GAME_JEWEL = 13;
    public static final int _SPR_GAME_JEWEL_SELECTOR = 14;
    public static final int _SPR_GAME_BONUS_SPECTRUM = 15;
    public static final int _SPR_GAME_BONUS_BOMB = 16;
    public static final int _SPR_GAME_BONUS_CROSS = 17;
    public static final int _SPR_GAME_BONUS_ESC_FALL = 18;
    public static final int _SPR_GAME_BLOCKS = 19;
    public static final int _SPR_GAME_PARTICLES = 20;
    public static final int _SPR_GAME_FLAME = 21;
    public static final int _SPR_ARROW = 22;
    public static final int _SPR_LANGUAGE = 23;
    public static final int _SPR_LEVEL_BTN = 24;
    public static final int _SPR_GAME_LEVEL_DECOR = 25;
    public static final int TOTAL_SPRS = 26;
    public static Sprite[] resSprs = new Sprite[26];
    public static final int GFONT_MAIN = 0;
    public static final int GFONT_GAME = 1;
    public static final int TOTAL_GFONTS = 2;
    public static GFont[] resGFonts = new GFont[2];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 1000;
    public static ResourceBundle[] resTexts = new ResourceBundle[1000];
    public static final int TEXT_MAIN_INSTRUCTIONS = 1;
    public static final int TEXT_REALY_QUIT = 2;
    public static final int TEXT_MAIN_ENABLE_MUSIC = 5;
    public static final int TEXT_MAIN_YES = 6;
    public static final int TEXT_MAIN_NO = 7;
    public static final int TEXT_LEVEL = 8;
    public static final int TEXT_COMPLETED = 9;
    public static final int TEXT_SCORE = 10;
    public static final int TEXT_TIMEISUP = 11;
    public static final int TEXT_NOMOREMOVES = 12;
    public static final int TEXT_GAMEOVER = 13;
    public static final int TEXT_CONTINUE = 14;
    public static final int TEXT_NEWRECORD = 15;
    public static final int TEXT_CONTROLS_NOTOUCH = 16;
    public static final int TEXT_CONTROLS_TOUCH_1 = 17;
    public static final int TEXT_MENU_ITEMS = 18;
    public static final int TEXT_MENU = 19;
    public static final int TEXT_BACK = 20;
    public static final int TEXT_NEW_GAME = 21;
    public static final int TEXT_INSTRUCT = 22;
    public static final int TEXT_ABOUT = 23;
    public static final int TEXT_CONT = 24;
    public static final int TEXT_RESTART = 25;
    public static final int TEXT_ON = 26;
    public static final int TEXT_OFF = 27;
    public static final int TEXT_SOUNDS = 28;
    public static final int TEXT_TUTORIAL_KEYBOARD = 29;
    public static final int TEXT_TUTORIAL_TOUCH = 30;
    public static final int TEXT_TUTORIAL_MOVES = 31;
    public static final int TEXT_TUTORIAL_BLOCKS = 32;
    public static final int TEXT_TUTORIAL_ESCAPE = 33;
    public static final int TEXT_TUTORIAL_DOWNFALL = 34;
    public static final int TEXT_TUTORIAL_TIME_ATTACK = 35;
    public static final int TEXT_GOALS_SCORE_GET = 36;
    public static final int TEXT_GOALS_SCORE_POINTS = 37;
    public static final int TEXT_GOALS_BLOCKS = 38;
    public static final int TEXT_GOALS_ESCAPE_POP = 39;
    public static final int TEXT_GOALS_ESCAPE_DIAMONDS = 40;
    public static final int TEXT_GOALS_DOWNFALL_BRING = 41;
    public static final int TEXT_GOALS_DOWNFALL_DIAMONDS = 42;
    public static final int TEXT_GOALS_MOVES_MAKE = 43;
    public static final int TEXT_GOALS_MOVES_TURNS = 44;
    public static final int TEXT_GOALS_TIME_ADD_WITHIN = 45;
    public static final int TEXT_GOALS_TIME_ADD_SECONDS = 46;
    public static final int TEXT_GOALS_TURNS_ADD_WITHIN = 47;
    public static final int TEXT_GOALS_TURNS_ADD_TURNS = 48;
    public static final int TEXT_RESULT_WELL_DONE = 49;
    public static final int TEXT_RESULT_GLAMOROUS = 50;
    public static final int TEXT_RESULT_SHINY = 51;
    public static final int TEXT_RESULT_GAME_OVER = 52;
    public static final int TEXT_CONTROLS_TOUCH_2 = 53;
    public static final int TEXT_CONTROLS_KEYS = 54;
    public static final int TEXT_RESULT_TITLE = 56;
    public static final int TEXT_RESULT_BOMB_LEFT = 57;
    public static final int TEXT_RESULT_DIAMOND = 58;
    public static final int TEXT_RESULT_RING = 59;
    public static final int TEXT_RESULT_TITLE_LOSE = 60;
    public static final int TEXT_RESULT_LOSE_OUT_OF_OPTIONS = 61;
    public static final int TEXT_RESULT_LOSE_BUBBLE_ESCAPED = 62;
    public static final int TEXT_RESULT_LOSE_OUT_OF_MOVES = 63;
    public static final int TEXT_RESULT_LOSE_OUT_OF_TIMES = 64;
    public static final int TEXT_RESULT_FAIL_POINTS = 65;
    public static final int TEXT_RESULT_FAIL_BLOCKS = 66;
    public static final int TEXT_RESULT_FAIL_RING = 67;
    public static final int TEXT_RESULT_FAIL_DIAMOND = 68;
    public static final int TEXT_RESULT_FAIL_MOVES = 69;
    public static final int TEXT_CLASSIC_PACK = 70;
    public static final int TEXT_BONUS_PACK = 71;
    public static final int TEXT_LAST_MESSAGE_FAIL = 72;
    public static final int TEXT_LAST_MESSAGE_OK = 73;
    public static final int TEXT_LAST_MESSAGE_SURPRISE = 74;
    public static final int TEXT_LAST_MESSAGE_BONUS_FAIL = 75;
    public static final int TEXT_LAST_MESSAGE_BONUS_OK = 76;
    public static final int TEXT_INGAME_REALY_QUIT = 77;
    public static final int TEXT_RESTART_QUESTIONS = 78;
    public static boolean sysFont;
    public static int widht;

    public static void initGraphicsDirs(int width, int height) {
        System.out.println(widht + " : " + width);
        graphicsBaseDir = "/" + width + "x" + height + "/";
        graphicsDisplayDir = "/" + width + "x" + height + "/";
        if (width == 240) {
            if (height > 320) {
                graphicsBaseDir = "/240x400/";
                graphicsDisplayDir = "/240x400/";
            } else {
                graphicsBaseDir = "/240x320/";
                graphicsDisplayDir = "/240x320/";
            }
        }
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            Common.trace(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "rot.png";
                break;
            }
            case 1: {
                imgPath = graphicsDisplayDir + "splash.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "bg.png";
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "logo.png";
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "game_name.png";
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "selektor_vlajky.png";
                break;
            }
            case 5: {
                imgPath = graphicsDisplayDir + "plocha_tile.png";
                break;
            }
            case 6: {
                imgPath = graphicsDisplayDir + "plocha_tile_obrys.png";
                break;
            }
            case 7: {
                imgPath = graphicsDisplayDir + "UI_star.png";
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "small_but_function.png";
                slicesX = 11;
                slicesY = 1;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "small_but.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "bigbut_items.png";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "bigbut_select.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "playbut_icon.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "playbut_select.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "level_complete_lock.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "twister3x62.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "stars_level.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "UI_window.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 12: {
                imgPath = graphicsBaseDir + "hornybar.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 11: {
                imgPath = graphicsBaseDir + "mode_indicator.png";
                slicesX = 5;
                slicesY = 1;
                break;
            }
            case 13: {
                imgPath = graphicsBaseDir + "cukre.png";
                slicesX = 7;
                slicesY = 1;
                break;
            }
            case 14: {
                imgPath = graphicsBaseDir + "selector_game.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 15: {
                imgPath = graphicsBaseDir + "bomb_color.png";
                slicesX = 7;
                slicesY = 1;
                break;
            }
            case 16: {
                imgPath = graphicsBaseDir + "bomb_around.png";
                slicesX = 7;
                slicesY = 7;
                break;
            }
            case 17: {
                imgPath = graphicsBaseDir + "bomb_row.png";
                slicesX = 7;
                slicesY = 7;
                break;
            }
            case 18: {
                imgPath = graphicsBaseDir + "light_heavy_candy.png";
                slicesX = 8;
                slicesY = 1;
                break;
            }
            case 19: {
                imgPath = graphicsBaseDir + "break_blocks.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "selector_level.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 20: {
                imgPath = graphicsBaseDir + "particle.png";
                slicesX = 3;
                slicesY = 7;
                break;
            }
            case 21: {
                imgPath = graphicsBaseDir + "expl.png";
                slicesX = 7;
                slicesY = 1;
                break;
            }
            case 22: {
                imgPath = graphicsBaseDir + "arrow_continue.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 23: {
                imgPath = graphicsBaseDir + "flags.png";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 24: {
                imgPath = graphicsBaseDir + "level_complete.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 25: {
                imgPath = graphicsBaseDir + "plocha_tile_obrys.png";
                slicesX = 1;
                slicesY = 1;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontMenu(Image gFontImg) {
        char[] fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c2', '\u00c3', '\u00c7', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '/', '(', ')', '.', ',', ':', ';', '\u201c', '!', '?', '\u00a1', '\u00bf', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        short[] fontCharWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 12: {
                fontCharWidth = new short[]{8, 7, 8, 7, 7, 7, 8, 8, 4, 5, 8, 6, 9, 7, 8, 8, 8, 7, 8, 7, 8, 8, 9, 8, 7, 7, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 4, 4, 3, 4, 8, 8, 8, 8, 8, 8, 8, 7, 7, 8, 5, 5, 4, 3, 2, 3, 3, 6, 4, 8, 5, 8, 4, 9, 6, 8, 8, 9, 9, 8, 7, 8, 7, 0};
                break;
            }
            case 16: {
                fontCharWidth = new short[]{10, 10, 11, 10, 9, 8, 11, 10, 6, 7, 10, 9, 12, 9, 11, 10, 11, 10, 10, 10, 10, 11, 11, 10, 11, 9, 10, 11, 10, 11, 10, 11, 9, 9, 10, 9, 6, 5, 5, 6, 9, 11, 10, 11, 11, 11, 9, 11, 10, 10, 7, 5, 6, 4, 3, 4, 4, 7, 7, 10, 6, 11, 6, 11, 9, 10, 11, 12, 11, 11, 10, 10, 11, 0};
                break;
            }
            case 21: {
                fontCharWidth = new short[]{14, 13, 13, 12, 12, 12, 13, 14, 7, 9, 13, 11, 15, 13, 14, 13, 14, 13, 13, 12, 14, 13, 14, 13, 13, 12, 14, 14, 14, 14, 13, 14, 12, 12, 12, 13, 6, 7, 7, 7, 13, 14, 13, 15, 13, 15, 13, 13, 13, 13, 9, 7, 7, 5, 5, 5, 5, 9, 8, 13, 7, 14, 9, 14, 11, 14, 14, 16, 13, 15, 14, 13, 13, 0};
                break;
            }
            case 23: {
                fontCharWidth = new short[]{15, 14, 15, 14, 13, 12, 15, 15, 8, 9, 14, 13, 16, 14, 15, 14, 15, 14, 15, 13, 14, 16, 16, 15, 15, 13, 15, 15, 15, 15, 15, 14, 13, 13, 14, 13, 7, 6, 8, 8, 14, 15, 15, 15, 15, 15, 14, 15, 14, 15, 9, 7, 8, 5, 6, 5, 6, 9, 8, 14, 8, 14, 9, 15, 12, 15, 15, 17, 15, 16, 15, 15, 14, 0};
                break;
            }
            case 31: {
                fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c2', '\u00c3', '\u00c7', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '/', '(', ')', '.', ',', ':', ';', '\u201c', '!', '?', '\u00a1', '\u00bf', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
                fontCharWidth = new short[]{20, 18, 19, 18, 17, 16, 20, 20, 10, 12, 19, 16, 21, 18, 20, 19, 20, 19, 19, 19, 19, 20, 21, 20, 19, 18, 21, 20, 20, 20, 20, 19, 17, 17, 17, 17, 10, 10, 10, 11, 17, 20, 19, 20, 21, 19, 19, 20, 18, 19, 13, 9, 9, 7, 7, 7, 7, 13, 12, 20, 12, 20, 12, 21, 16, 20, 20, 23, 20, 21, 20, 19, 20, 0};
                break;
            }
            default: {
                fontCharWidth = new short[]{10, 10, 11, 10, 9, 8, 11, 10, 6, 7, 10, 9, 12, 9, 11, 10, 11, 10, 10, 10, 10, 11, 11, 10, 11, 9, 10, 11, 10, 11, 10, 11, 9, 9, 10, 9, 6, 5, 5, 6, 9, 11, 10, 11, 11, 11, 9, 11, 10, 10, 7, 5, 6, 4, 3, 4, 4, 7, 7, 10, 6, 11, 6, 11, 9, 10, 11, 12, 11, 11, 10, 10, 11, 0};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharWidth, spaceBetweenChars, fontCharWidth[0]);
    }

    private static GFont createGFontGame(Image gFontImg) {
        char[] fontChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', '/', 'm', 'd', '*'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 14: {
                fontCharsWidth = new short[]{13, 11, 12, 14, 14, 13, 13, 13, 12, 13, 6, 8, 19, 14, 13, 0};
                break;
            }
            case 18: {
                fontCharsWidth = new short[]{16, 14, 17, 17, 19, 16, 17, 17, 16, 17, 8, 11, 25, 19, 18, 0};
                break;
            }
            case 25: {
                fontCharsWidth = new short[]{22, 19, 22, 22, 25, 21, 22, 22, 21, 23, 10, 15, 33, 25, 24, 0};
                break;
            }
            case 28: {
                fontCharsWidth = new short[]{25, 22, 24, 24, 28, 24, 25, 25, 24, 26, 12, 16, 37, 28, 28, 0};
                break;
            }
            case 37: {
                fontCharsWidth = new short[]{32, 27, 32, 32, 36, 31, 33, 32, 31, 33, 15, 21, 49, 37, 37, 0};
                break;
            }
            default: {
                fontCharsWidth = new short[]{16, 14, 17, 17, 19, 16, 17, 17, 16, 17, 8, 11, 25, 19, 18, 0};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "gameinfo_font.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGame(gFontImg);
                break;
            }
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "menu_font.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMenu(gFontImg);
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        langDir = "/lang/" + langCode + "/";
        if (langCode == "ru" || langCode == "cn") {
            sysFont = true;
        }
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    static {
        widht = 0;
    }
}

