/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class ScreenSplash
implements IScreen {
    static final int MODE_SET_RES = 0;
    static final int MODE_LOADING = 1;
    static final int MODE_LANGUAGE = 2;
    static final int MODE_COMPANY_LOGO = 3;
    static final int MODE_MUSIC = 4;
    static final int MODE_GAME_LOGO = 5;
    static final int MODE_MENU = 6;
    public static String strLangPrefix = "en";
    Canvas canvas;
    int mode;
    long modeDelay;
    int iFlagX;
    int iFlagY;
    int iFlagGap;
    int iFlagSelX;
    int iFlagSelY;
    int iLangSelectorX;
    int iLangSelectorY;
    int iFlagW;
    int iFlagH;
    int iSoundIdx;
    int iMusicPosX;
    int iMusicPosY;
    int iMusicIconW;
    private int iLogoPosY = 0;
    String strMusic;

    ScreenSplash(Canvas canvas) {
        this.canvas = canvas;
        this.prepareFirstRun();
    }

    public int getActualMode() {
        return this.mode;
    }

    public String getActualModeName() {
        return "Screen splash";
    }

    public void invokeGameMenu() {
    }

    public void update(int tick) {
        MainCanvas.setAverageFps(tick);
        switch (this.mode) {
            case 0: {
                break;
            }
            case 1: {
                Resources.loadGameResources();
                Resources.loadMenuRes();
                Resources.loadInitialResources();
                Resources.loadGame();
                Resources.loadMenu();
                this.callModeLanguage();
                state.loadGlobals();
                break;
            }
            case 3: {
                if (this.modeDelay > 0L) {
                    this.modeDelay -= (long)tick;
                    return;
                }
                this.callModeGameLogo();
                break;
            }
            case 5: {
                if (this.modeDelay > 0L) {
                    this.modeDelay -= (long)tick;
                    return;
                }
                MainCanvas.scrMenu = new ScreenMenu(this.canvas, false);
                MainCanvas.activeScreen = MainCanvas.scrMenu;
                MainCanvas.scrSplash = null;
            }
        }
        this.canvas.repaint();
    }

    public void paint(Graphics g) {
        switch (this.mode) {
            case 0: {
                this.paintInitialScreen(g);
                break;
            }
            case 2: {
                this.paintLanguageSelection(g);
                break;
            }
            case 3: {
                Resources.paintBackground(g);
                break;
            }
            case 5: {
                this.paintGameLogo(g);
                break;
            }
            case 4: {
                this.paintMusicSelection(g);
            }
        }
    }

    public void prepareFirstRun() {
        this.mode = 0;
    }

    public void paintInitialScreen(Graphics g) {
        MainCanvas.iRealWidth = this.canvas.getWidth();
        MainCanvas.iRealHeight = this.canvas.getHeight();
        Defines.WIDTH = MainCanvas.iRealWidth;
        Defines.HEIGHT = MainCanvas.iRealHeight;
        Resources.setParamsByRes(Defines.WIDTH, Defines.HEIGHT);
        Resources.paintGameBackground(g);
        if (MainCanvas.iRealWidth != 0 && MainCanvas.iRealHeight != 0) {
            MainCanvas.checkStartupRes();
            this.mode = 1;
        }
    }

    public void paintLanguageSelection(Graphics g) {
        Resources.paintGameBackground(g);
        Resources.paintWindow(g);
        this.strMusic = Globals.strLangHeader[this.iLangSelectorY * 3 + this.iLangSelectorX];
        Fonts.gf1.DrawText(g, Defines.WIDTH - Fonts.stringWidth(this.strMusic, 0) >> 1, Resources.iWinPosY + this.iFlagGap, this.strMusic);
        if (Resources.sprFlags != null) {
            for (int i = 0; i < 6; ++i) {
                Resources.sprFlags.setFrame(i + (i / 2 == this.iLangSelectorX && i % 2 == this.iLangSelectorY ? 6 : 0));
                Resources.sprFlags.setPosition(this.iFlagX + i / 2 * (Resources.iFlagsW + this.iFlagGap), this.iFlagY + i % 2 * (Resources.iFlagsH + this.iFlagGap));
                Resources.sprFlags.paint(g);
            }
        }
    }

    public void paintGameLogo(Graphics g) {
        Resources.paintGameBackground(g);
        g.drawImage(Resources.imgLogo, Defines.WIDTH >> 1, Defines.HEIGHT >> 1, 3);
    }

    public void paintMusicSelection(Graphics g) {
        Resources.paintGameBackground(g);
        Resources.paintWindow(g);
        Fonts.gf1.DrawText(g, Defines.WIDTH - Fonts.stringWidth(this.strMusic, 0) >> 1, Resources.iWinPosY + this.iFlagGap, this.strMusic);
        for (int i = 0; i < 2; ++i) {
            Resources.sprMnIc.setFrame(5 + i + (this.iSoundIdx == i ? Resources.iFrameCnt : 0));
            Resources.sprMnIc.setPosition(this.iMusicPosX + i * this.iMusicIconW, this.iMusicPosY);
            Resources.sprMnIc.paint(g);
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this.mode) {
            case 2: {
                if (Keys.key_left) {
                    this.moveLangLeft();
                }
                if (Keys.key_right) {
                    this.moveLangRight();
                }
                if (Keys.key_up) {
                    this.moveLangUp();
                }
                if (Keys.key_down) {
                    this.moveLangDown();
                }
                if (!Keys.key_fire) break;
                this.executeSelection();
                break;
            }
            case 4: {
                if (Keys.key_left) {
                    this.updateMusicSelection(true);
                }
                if (Keys.key_right) {
                    this.updateMusicSelection(false);
                }
                if (!Keys.key_fire) break;
                this.setMusic();
                break;
            }
            case 3: {
                this.modeDelay = 0L;
                break;
            }
            case 5: {
                this.modeDelay = 0L;
            }
        }
    }

    public void updateMusicSelection(boolean bLeft) {
        if (bLeft) {
            if (--this.iSoundIdx < 0) {
                this.iSoundIdx = 0;
            }
        } else if (++this.iSoundIdx > 1) {
            this.iSoundIdx = 1;
        }
    }

    public void setMusic() {
        if (this.iSoundIdx == 0) {
            Settings.bMusic = true;
            this.callModeLogo();
        } else {
            Settings.bMusic = false;
            this.callModeLogo();
        }
    }

    public void enableMusic() {
        Settings.bMusic = true;
        this.callModeLogo();
    }

    public void disableMusic() {
        Settings.bMusic = false;
        this.callModeLogo();
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        if (Resources.isInLeftButton(x, y)) {
            Keys.key_fn1 = true;
            Keys.key_fn2 = false;
            this.keyReleased(Keys.iLeftKey);
            return;
        }
        if (Resources.isInRightButton(x, y)) {
            Keys.key_fn1 = false;
            Keys.key_fn2 = true;
            this.keyReleased(Keys.iRightKey);
            return;
        }
        switch (this.mode) {
            case 2: {
                if (x <= this.iFlagX || x >= this.iFlagX + this.iFlagW || y <= this.iFlagY || y >= this.iFlagY + this.iFlagH) break;
                this.iLangSelectorX = (x - this.iFlagX) / (this.iFlagW / 3);
                this.iLangSelectorY = (y - this.iFlagY) / (this.iFlagH / 2);
                this.executeSelection();
                break;
            }
            case 4: {
                if (x <= this.iMusicPosX || x >= this.iMusicPosX + 2 * this.iMusicIconW || y <= this.iMusicPosY || y >= this.iMusicPosY + Resources.iMnIcH) break;
                int musicidx = (x - this.iMusicPosX) / this.iMusicIconW;
                if (musicidx == 0) {
                    Settings.bMusic = true;
                    this.callModeLogo();
                    break;
                }
                if (musicidx != 1) break;
                Settings.bMusic = false;
                this.callModeLogo();
                break;
            }
            case 3: {
                this.modeDelay = 0L;
                break;
            }
            case 5: {
                this.modeDelay = 0L;
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void callModeLanguage() {
        this.iFlagGap = Resources.iLangSpace;
        this.iFlagX = Defines.WIDTH - 3 * Resources.iFlagsW - 2 * this.iFlagGap >> 1;
        this.iFlagY = Resources.iWinPosY + Fonts.getGraphicsFontH(0) + (Resources.iMenuWinH - 2 * Resources.iFlagsH - this.iFlagGap - Fonts.getGraphicsFontH(0) >> 1);
        this.iFlagW = 3 * Resources.iFlagsW + 2 * this.iFlagGap;
        this.iFlagH = 2 * Resources.iFlagsW + 1 * this.iFlagGap;
        this.mode = 2;
    }

    public void callModeLogo() {
        Resources.releaseFlags();
        Resources.imgBackground = Common.createImage("/inl.png");
        this.modeDelay = 1500L;
        this.mode = 3;
    }

    public void callModeGameLogo() {
        this.modeDelay = 1500L;
        this.iLogoPosY = Defines.HEIGHT >> 1;
        this.mode = 5;
    }

    public void moveLangLeft() {
        if (--this.iLangSelectorX < 0) {
            this.iLangSelectorX = 0;
        }
    }

    public void moveLangRight() {
        if (++this.iLangSelectorX > 2) {
            this.iLangSelectorX = 2;
        }
    }

    public void moveLangUp() {
        if (--this.iLangSelectorY < 0) {
            this.iLangSelectorY = 0;
        }
    }

    public void moveLangDown() {
        if (++this.iLangSelectorY > 1) {
            this.iLangSelectorY = 1;
        }
    }

    public void executeSelection() {
        int iSelected = this.iLangSelectorY * 3 + this.iLangSelectorX;
        if (iSelected == 0) {
            strLangPrefix = "en";
        } else if (iSelected == 1) {
            strLangPrefix = "pt";
        } else if (iSelected == 2) {
            strLangPrefix = "it";
        } else if (iSelected == 3) {
            strLangPrefix = "de";
        } else if (iSelected == 4) {
            strLangPrefix = "fr";
        } else if (iSelected == 5) {
            strLangPrefix = "es";
        }
        ResTexts.STRING_BIN = "/lang/" + strLangPrefix + "/text.txt";
        this.callMusicSelection();
    }

    public void callMusicSelection() {
        Settings.bMusic = false;
        this.callModeLogo();
    }

    public void callMenu() {
        MainCanvas.scrMenu = new ScreenMenu(this.canvas, false);
        MainCanvas.activeScreen = MainCanvas.scrMenu;
        MainCanvas.scrSplash = null;
    }
}

