/*
 * Decompiled with CFR 0.152.
 */
package iec.octopusblast;

import iec.octopusblast.BarrierMenu;
import iec.octopusblast.DragText;
import iec.octopusblast.Effectelement;
import iec.octopusblast.Func;
import iec.octopusblast.GameMID;
import iec.octopusblast.IECRecordStore;
import iec.octopusblast.MainCanvas;
import iec.octopusblast.Menu;
import iec.octopusblast.ObstacleFish;
import iec.octopusblast.Set;
import iec.octopusblast.SetBarrier;
import iec.octopusblast.SetLanguage;
import iec.octopusblast.SetValues;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class OctopusBlasts {
    final byte elementNum = (byte)8;
    Image gameBack;
    Image[] linkImg;
    int linkW;
    int linkH;
    Image selectImg;
    Image selectBigImg;
    Image elementImg;
    Image elementBigImg;
    int elementW = 27;
    int elementH = 27;
    int elementBigW;
    int elementBigH;
    int elementGridW = 29;
    int elementGridH = 29;
    Image elementfuncImg;
    Image elementfuncBigImg;
    int elementFuncW;
    int elementFuncH;
    int elementFuncBigW;
    int elementFuncBigH;
    Image scoreNoImg;
    int scoreW;
    int scoreH;
    Vector v_score;
    int score = 0;
    int totalScore = 0;
    int tempScore = 0;
    String totalScoreStr = "0";
    String alltotalScoreStr = "0";
    String highScoreStr = "";
    int[][] gameData;
    int[] gameNumData;
    int data_horizontal_no = SetValues.data_horizontal_no;
    int data_vertical_no = 15;
    int show_vertical_no = SetValues.show_vertical_no;
    int stageNo;
    String stageNOstr;
    int selectBuoy = -this.show_vertical_no / 2;
    int selectI;
    int selectJ;
    int selectedI = -1;
    int selectedJ = -1;
    Vector v_selectData;
    Vector v_LinkData;
    short batterTimes = 0;
    int[][] linkOneData;
    final byte threeTimeParam;
    byte twoBatterTimeParam = (byte)20;
    long twoBatterTime = 0L;
    byte upMuch = 1;
    int upHeightStep = 5;
    int upOtherTimeParam = 10;
    int upTotalHeight = 0;
    long upTime = 0L;
    boolean ischeckfly = false;
    long ischeckflyTime = 0L;
    byte[][] checkfly;
    Vector v_Effect;
    Image comboImg;
    Image comboXImg;
    Image comboxNoImg;
    Image superCombo;
    int comboxNoW;
    int comboxNoH;
    String comboxStr = "";
    String timeStr = "";
    int timeScore = 0;
    byte effectTimeParam = (byte)8;
    long effectTime = 0L;
    int startTime;
    int startStep;
    Vector v_explosion;
    byte explosoinTimeParam = (byte)100;
    int[][] recordData;
    byte changTimeParam = (byte)60;
    long changTime = 0L;
    int changPosition = 0;
    final byte isStart;
    final byte isStop = (byte)3;
    final byte wining = (byte)4;
    final byte isWin = (byte)5;
    final byte timeOut = (byte)6;
    final byte gaming;
    byte gameState = 1;
    byte recordState;
    int totalTimeStep;
    int currentTimeStep = 0;
    long gameStartTime;
    int totalTime;
    Image scoreBackImg;
    Image scoreWordImg;
    Image levelImg;
    Image levelNoImg;
    int levelNoW;
    int levelNoH;
    Image gameOverWordImg;
    Image levelCompleteImg;
    Image scoreStarImg;
    byte scoreStarNo = 0;
    boolean haveFish = false;
    ObstacleFish ofish;
    Vector v_star;
    byte warntimeParm = (byte)6;
    byte warnStep = 0;
    boolean iskuaisudaoshu = false;
    boolean stopToSettingOrHelp = false;
    long stoptime = 0L;
    long canStopTime;
    int secondTimes;
    int startx;
    int starty;
    BarrierMenu bm;
    int selectStopMenu;
    Image stopMenuImg;
    Image stopSelectImg;
    int linkn;
    byte comboTimeTo;
    int comboPositionX;
    int comboPositionY;
    int comboPositionS;
    int comboPositionV;
    byte comboA;
    int gamingkey;
    Image starImg;
    int starW;
    int starH;
    byte starNumParam;

    public OctopusBlasts(BarrierMenu bm, int stage) {
        this.threeTimeParam = 1;
        this.isStart = 1;
        this.gaming = 0;
        GameMID.sc.getClass();
        this.secondTimes = 1000 / 50;
        this.startx = 0;
        this.starty = 0;
        this.selectStopMenu = 0;
        this.linkn = 0;
        this.comboTimeTo = 0;
        this.comboPositionS = 0;
        this.comboA = (byte)2;
        this.gamingkey = 1000;
        this.starNumParam = 1;
        this.bm = bm;
        this.stageNo = stage;
        this.stageNOstr = String.valueOf(stage);
        this.setBarrier(stage);
        this.init();
    }

    public void restart() {
        this.v_Effect.removeAllElements();
        this.v_LinkData.removeAllElements();
        this.v_selectData.removeAllElements();
        this.v_explosion.removeAllElements();
        this.v_score.removeAllElements();
        this.v_star.removeAllElements();
        this.ischeckfly = false;
        this.twoBatterTime = 0L;
        this.upTime = 0L;
        this.canStopTime = 0L;
        this.ischeckflyTime = 0L;
        this.effectTime = 0L;
        this.changTime = 0L;
        this.tempScore = 0;
        this.totalScore = 0;
        this.totalScoreStr = "0";
        this.alltotalScoreStr = "0";
        this.selectedI = -1;
        this.selectedJ = -1;
        this.startTime = 0;
        this.startStep = 0;
        this.setBarrier(this.stageNo);
        this.currentTimeStep = 0;
        this.iskuaisudaoshu = false;
        this.scoreStarNo = 0;
        this.upTotalHeight = 0;
        if (this.ofish != null) {
            this.ofish.restart();
        }
        this.gameState = 1;
        MainCanvas.menu.playMusic(true);
    }

    public void setBarrier(int stage) {
        int[][][] b = SetBarrier.barrierSet(stage);
        this.gameData = b[1];
        this.data_vertical_no = b[1].length;
        this.gameNumData = b[0][0];
        this.twoBatterTimeParam = (byte)b[0][1][1];
        this.upOtherTimeParam = b[0][1][2];
        if (b[0][1][3] == 1) {
            this.haveFish = true;
            if (this.ofish == null) {
                this.ofish = new ObstacleFish();
            }
        } else {
            this.haveFish = false;
        }
        this.totalTimeStep = b[0][1][4] * this.secondTimes;
        this.selectBuoy = -this.show_vertical_no / 2;
        int maxi = this.getMaxi();
        int j = 0;
        while (j < this.data_horizontal_no - 1) {
            if (this.isFourBody(maxi, j) == 1) {
                this.setFourBody(maxi, j);
            }
            ++j;
        }
        this.selectI = this.show_vertical_no - -this.selectBuoy + 1;
        this.selectJ = 0;
    }

    protected void init() {
        this.selectI = this.show_vertical_no - -this.selectBuoy + 1;
        this.selectJ = 0;
        this.checkfly = new byte[this.show_vertical_no][this.data_horizontal_no];
        this.v_Effect = new Vector();
        this.v_LinkData = new Vector();
        this.v_selectData = new Vector();
        this.v_explosion = new Vector();
        this.v_score = new Vector();
        this.v_star = new Vector();
    }

    public void initRes(int num) {
        switch (num) {
            case 3: {
                this.gameBack = GameMID.sc.GameBackImg;
                break;
            }
            case 6: {
                this.elementImg = Func.crtImg("/elements.png");
                this.elementGridW = this.elementW = this.elementImg.getWidth() / 8;
                this.elementGridH = this.elementH = this.elementImg.getHeight();
                this.upHeightStep = this.elementGridH / 5;
                break;
            }
            case 9: {
                this.elementBigImg = Func.crtImg("/elements_big.png");
                this.elementBigW = this.elementBigImg.getWidth() / 8;
                this.elementBigH = this.elementBigImg.getHeight();
                break;
            }
            case 12: {
                this.superCombo = Func.crtImg("/super_combo.png");
                break;
            }
            case 15: {
                this.elementfuncImg = Func.crtImg("/elementfunc.png");
                this.elementFuncW = this.elementfuncImg.getWidth();
                this.elementFuncH = this.elementfuncImg.getHeight() >> 1;
                break;
            }
            case 18: {
                this.elementfuncBigImg = Func.crtImg("/elementfunc_big.png");
                this.elementFuncBigW = this.elementfuncBigImg.getWidth();
                this.elementFuncBigH = this.elementfuncBigImg.getHeight() >> 1;
                break;
            }
            case 21: {
                this.scoreNoImg = Func.crtImg("/score_num.png");
                this.scoreW = this.scoreNoImg.getWidth() / 11;
                this.scoreH = this.scoreNoImg.getHeight();
                break;
            }
            case 24: {
                this.linkImg = new Image[2];
                this.linkImg[0] = Func.crtImg("/link.png");
                this.linkW = this.linkImg[0].getWidth();
                this.linkH = this.linkImg[0].getWidth() / 2;
                this.linkImg[1] = Image.createImage((Image)this.linkImg[0], (int)0, (int)0, (int)this.linkW, (int)(this.linkH * 2), (int)5);
                break;
            }
            case 27: {
                this.selectImg = Func.crtImg("/select.png");
                this.selectBigImg = Func.crtImg("/select_big.png");
                break;
            }
            case 30: {
                this.starImg = Func.crtImg("/star.png");
                this.starW = this.starImg.getWidth();
                this.starH = this.starImg.getHeight() / 4;
                break;
            }
            case 33: {
                this.comboImg = Func.crtImg("/combox.png");
                this.comboXImg = Func.crtImg("/combox_x.png");
                this.comboxNoImg = Func.crtImg("/combox_num.png");
                this.comboxNoW = this.comboxNoImg.getWidth() / 11;
                this.comboxNoH = this.comboxNoImg.getHeight();
                break;
            }
            case 36: {
                this.stopMenuImg = Func.crtImg("/stop_menu.png");
                this.stopSelectImg = Func.crtImg("/stop_select.png");
                break;
            }
            case 39: {
                this.scoreBackImg = Func.crtImg("/score_back.png");
                break;
            }
            case 40: {
                this.scoreWordImg = Func.crtImg("/score_word.png");
                break;
            }
            case 42: {
                this.levelImg = Func.crtImg("/level.png");
                this.levelNoImg = Func.crtImg("/levelnum.png");
                this.levelNoW = this.levelNoImg.getWidth() / 10;
                this.levelNoH = this.levelNoImg.getHeight();
                break;
            }
            case 45: {
                this.gameOverWordImg = Func.crtImg("/gameover.png");
                break;
            }
            case 48: {
                this.levelCompleteImg = Func.crtImg("/score_complete.png");
                this.scoreStarImg = Func.crtImg("/score_star.png");
                break;
            }
            case 51: {
                Effectelement.initEffectRes();
                break;
            }
        }
    }

    public int isFourBody(int i, int j) {
        if (i >= 0 && i < this.gameData.length && j >= 0 && j < this.data_horizontal_no) {
            return this.isFourBody(this.gameData[i][j]);
        }
        return 0;
    }

    public int isFourBody(int data) {
        if (data > 50 && data <= 58) {
            return 1;
        }
        if (data > 150 && data < 158) {
            return 2;
        }
        if (data > 250 && data < 258) {
            return 3;
        }
        if (data > 350 && data < 358) {
            return 4;
        }
        return 0;
    }

    private void setFourBody(int maxi, int j) {
        this.gameData[maxi][j] = this.gameData[maxi][j] - 50;
        this.gameData[maxi][j + 1] = this.gameData[maxi][j];
        this.gameData[maxi + 1][j] = this.gameData[maxi][j];
        this.gameData[maxi + 1][j + 1] = this.gameData[maxi][j];
    }

    public void draw(Graphics g) {
        switch (this.gameState) {
            case 3: {
                this.drawStop(g);
                break;
            }
            case 0: {
                this.drawGame(g);
                MainCanvas.menu.drawGameMenu(g);
                break;
            }
            case 1: {
                this.drawGame(g);
                this.drawStart(g);
                break;
            }
            case 6: {
                this.drawGame(g);
                this.drawTimeOut(g);
                break;
            }
            case 4: {
                this.drawGame(g);
                this.drawWining(g);
                break;
            }
            case 5: {
                this.drawGame(g);
                this.drawIsWin(g);
            }
        }
    }

    public void drawStop(Graphics g) {
        int w = this.stopMenuImg.getWidth();
        int w1 = this.stopSelectImg.getWidth();
        int h = this.stopMenuImg.getHeight() / 4;
        int h1 = this.stopSelectImg.getHeight();
        int x = (Set.width - w - 2 * w1) / 2;
        int y = MainCanvas.menu.kuang_y + SetValues.stopMenuYOff;
        int height = MainCanvas.menu.kuangImgH / 6;
        g.drawImage(MainCanvas.menu.otherback, 0, 0, 0);
        int i = 0;
        while (i < 4) {
            g.setClip(x + 2 * w1, y + (i + 1) * height, w, h);
            g.drawImage(this.stopMenuImg, x + 2 * w1, y + (i + 1) * height - i * h, 0);
            if (this.selectStopMenu == i) {
                g.setClip(x, y + (i + 1) * height + (h - h1) / 2, this.stopSelectImg.getWidth(), this.stopSelectImg.getHeight());
                g.drawImage(this.stopSelectImg, x, y + (i + 1) * height + (h - h1) / 2, 0);
            }
            ++i;
        }
        MainCanvas.menu.drawSoftkey(g, 0, 1);
    }

    private void drawStart(Graphics g) {
        int x = Set.width - this.levelImg.getWidth() - this.levelNoW * 3 >> 1;
        int y = Set.height * 2 / 5 - this.levelNoH - this.startStep;
        g.drawImage(this.levelImg, x, y, 0);
        this.drawScore(g, x += this.levelImg.getWidth() + this.levelNoW, y += this.levelImg.getHeight() - this.levelNoH >> 1, this.stageNOstr, 1, this.levelNoW, this.levelNoH, this.levelNoImg);
    }

    private void drawGame(Graphics g) {
        MainCanvas.setClipFullScreen(g);
        g.drawImage(this.gameBack, 0, 0, 0);
        int x = 0 + SetValues.gametimeXoff;
        int y = 0;
        int w = Set.width * 5 / 6;
        int h = SetValues.gameHeight;
        this.drawTimes(g, x, y, w, h);
        x = this.totalScoreStr.length() > 4 ? Set.width + SetValues.shipPositionX - 3 * this.scoreW : Set.width + SetValues.shipPositionX - 2 * this.scoreW;
        y = h - this.scoreH >> 1;
        this.drawScore(g, x, y + this.scoreH >> 1, this.totalScoreStr, 2, this.scoreW, this.scoreH, this.scoreNoImg);
        y = y + h + SetValues.elementAllYoff;
        w = this.data_horizontal_no * this.elementGridW;
        h = this.show_vertical_no * this.elementGridH;
        x = Set.width - w >> 1;
        y += Set.height - h - y >> 1;
        if (this.startx == 0 && this.starty == 0) {
            this.startx = x;
            this.starty = y;
        }
        y += this.upTotalHeight;
        int select = 0;
        int i = 0;
        while (i < this.show_vertical_no) {
            if ((i < 0 || i > 1 || this.warnStep <= 0 || this.warnStep > this.warntimeParm || this.gameState != 0) && (select = this.selectBuoy + i) >= 0 && select < this.data_vertical_no) {
                int j = 0;
                while (j < this.data_horizontal_no) {
                    if (select == this.selectedI && j == this.selectedJ) {
                        this.drawElement(g, x + j * this.elementGridW, y + i * this.elementGridH, select, j, 1);
                    } else {
                        this.drawElement(g, x + j * this.elementGridW, y + i * this.elementGridH, select, j, 0);
                    }
                    if (i == this.selectI && j == this.selectJ && this.gameState == 0) {
                        this.drawSelect(g, x + j * this.elementGridW, y + i * this.elementGridH, select, j);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.drawLine(g, x, y);
        i = 0;
        while (i < this.v_Effect.size()) {
            ((Effectelement)this.v_Effect.elementAt(i)).draw(g);
            ++i;
        }
        i = 0;
        while (i < this.v_score.size() / 2) {
            int[] d = (int[])this.v_score.elementAt(i * 2);
            this.drawScore(g, d[0], d[1] - d[2], (String)this.v_score.elementAt(i * 2 + 1), 2, this.comboxNoW, this.comboxNoH, this.comboxNoImg);
            d[2] = d[2] + 1;
            if (d[2] > this.elementGridH / 3) {
                this.v_score.removeElementAt(i * 2 + 1);
                this.v_score.removeElement(d);
            }
            ++i;
        }
        this.drawComBox(g);
        i = 0;
        while (i < this.v_star.size()) {
            ((Star)this.v_star.elementAt(i)).draw(g);
            ++i;
        }
        if (this.haveFish && this.ofish != null) {
            this.ofish.draw(g);
        }
    }

    private void drawElement(Graphics g, int x, int y, int i, int j, int selected) {
        int data = this.gameData[i][j];
        if (data > 0 && data <= 8) {
            x += this.elementGridW - this.elementW >> 1;
            y += this.elementGridH - this.elementH >> 1;
            if (selected == 1) {
                g.setClip(x -= this.elementW / 6, y -= this.elementH / 6, this.elementW, this.elementH);
                g.drawImage(this.elementImg, x - (data - 1) * this.elementW, y, 0);
                g.drawImage(this.selectImg, x, y, 0);
            } else {
                g.setClip(x, y, this.elementW, this.elementH);
                g.drawImage(this.elementImg, x - (data - 1) * this.elementW, y, 0);
            }
        } else if (this.isFourBody(i, j) == 1) {
            x += this.elementGridW * 2 - this.elementBigW >> 1;
            y += this.elementGridH * 2 - this.elementBigH >> 1;
            data -= 50;
            if (selected == 1) {
                g.setClip(x -= this.elementW / 6, y -= this.elementH / 6, this.elementBigW, this.elementBigH);
                g.drawImage(this.elementBigImg, x - (data - 1) * this.elementBigW, y, 0);
                g.drawImage(this.selectBigImg, x, y, 0);
            } else {
                g.setClip(x, y, this.elementBigW, this.elementBigH);
                g.drawImage(this.elementBigImg, x - (data - 1) * this.elementBigW, y, 0);
            }
        } else if (!(data > 150 && data <= 158 || data > 250 && data <= 258 || data > 350 && data <= 358)) {
            if (data == 99) {
                if (this.gameState != 0 && this.gameState != 6) {
                    return;
                }
                g.setClip(x += this.elementGridW - Effectelement.chongW >> 1, y += this.elementGridH - Effectelement.chongH >> 1, Effectelement.chongW, Effectelement.chongH);
                g.drawImage(Effectelement.chongImg, x, y, 0);
            } else if (data == 98) {
                if (this.gameState != 0 && this.gameState != 6) {
                    return;
                }
                g.setClip(x += this.elementGridW - Effectelement.bombW >> 1, y += this.elementGridH - Effectelement.bombH >> 1, Effectelement.bombW, Effectelement.bombH);
                g.drawImage(Effectelement.bombImg, x, y, 0);
            } else if (data < 0) {
                if (data > -100) {
                    this.checkEffect(i, j, data);
                }
                int one = this.secondTimes * 1 / 4;
                int times = -data / 100;
                if ((data = -data % 100) > 0 && data <= 8) {
                    g.setClip(x += this.elementGridW - this.elementW >> 1, y += this.elementGridH - this.elementH >> 1, this.elementW, this.elementH);
                    g.drawImage(this.elementImg, x - (data - 1) * this.elementW, y, 0);
                    this.addStarToElement(x, y, false);
                    g.setClip(x += this.elementW - this.elementFuncW >> 1, y += this.elementH - this.elementFuncH >> 1, this.elementFuncW, this.elementFuncH);
                    if (times < one * 2) {
                        g.drawImage(this.elementfuncImg, x, y, 0);
                    } else {
                        g.drawImage(this.elementfuncImg, x, y - this.elementFuncH, 0);
                    }
                } else {
                    g.setClip(x += this.elementGridW * 2 - this.elementBigW >> 1, y += this.elementGridH * 2 - this.elementBigH >> 1, this.elementBigW, this.elementBigH);
                    g.drawImage(this.elementBigImg, x - ((data -= 50) - 1) * this.elementBigW, y, 0);
                    this.addStarToElement(x, y, true);
                    g.setClip(x += this.elementBigW - this.elementFuncBigW >> 1, y += this.elementBigH - this.elementFuncBigH >> 1, this.elementFuncBigW, this.elementFuncBigH);
                    if (times < one * 2) {
                        g.drawImage(this.elementfuncBigImg, x, y, 0);
                    } else {
                        g.drawImage(this.elementfuncBigImg, x, y - this.elementFuncBigH, 0);
                    }
                }
                int[] nArray = this.gameData[i];
                int n = j;
                nArray[n] = nArray[n] - 100;
                if (times >= this.secondTimes * 1) {
                    this.gameData[i][j] = 0;
                }
            }
        }
        MainCanvas.setClipFullScreen(g);
    }

    private void drawSelect(Graphics g, int x, int y, int i, int j) {
        g.setColor(65280);
        if (this.isFourBody(i, j) == 1) {
            g.drawImage(this.selectBigImg, x += this.elementGridW * 2 - this.elementBigW >> 1, y += this.elementGridH * 2 - this.elementBigH >> 1, 0);
        } else {
            g.drawImage(this.selectImg, x += this.elementGridW - this.elementW >> 1, y += this.elementGridH - this.elementH >> 1, 0);
        }
    }

    private void checkEffect(int i, int j, int data) {
        if ((data = -data % 100) > 0 && data <= 8) {
            if (i > 0) {
                this.toEffect(i - 1, j);
            }
            if (i < this.getMaxi()) {
                this.toEffect(i + 1, j);
            }
            if (j > 0) {
                this.toEffect(i, j - 1);
            }
            if (j < this.data_horizontal_no - 1) {
                this.toEffect(i, j + 1);
            }
        } else if (data > 50 && data <= 58) {
            if (i > 0) {
                this.toEffect(i - 1, j);
                this.toEffect(i - 1, j + 1);
            }
            if (i < this.getMaxi() - 1) {
                this.toEffect(i + 2, j);
                this.toEffect(i + 2, j + 1);
            }
            if (j > 0) {
                this.toEffect(i, j - 1);
                this.toEffect(i + 1, j - 1);
            }
            if (j < this.data_horizontal_no - 2) {
                this.toEffect(i, j + 2);
                this.toEffect(i + 1, j + 2);
            }
        }
    }

    private void toEffect(int i, int j) {
        if (this.gameData[i][j] == 98) {
            this.explosoinEffect(i, j);
        } else if (this.gameData[i][j] == 99) {
            this.chongEffect(i, j);
        }
    }

    public void explosoinEffect(int i, int j) {
        int maxi = this.v_explosion.size() / 2;
        int j2 = 0;
        while (j2 < maxi) {
            int[] p = (int[])this.v_explosion.elementAt(j2 * 2 + 1);
            if (i == p[0] && j == p[1]) {
                this.v_explosion.removeElementAt(j2 * 2);
                this.v_explosion.removeElement(p);
                break;
            }
            ++j2;
        }
        maxi = this.getMaxi();
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(new Integer(i));
        vector.addElement(new Integer(j));
        vector.addElement(new Integer(98));
        int n = 0;
        int k = 0;
        while (k < 3) {
            int p = 0;
            while (p < 3) {
                if (i != i + k - 1 || j != j + p - 1) {
                    int mi = i + k - 1;
                    int mj = j + p - 1;
                    if (mi >= 0 && mi <= maxi && mj >= 0 && mj < this.data_horizontal_no && this.isHaveElement(mi, mj)) {
                        n = this.isFourBody(mi, mj);
                        if (n == 2) {
                            --mj;
                        } else if (n == 3) {
                            --mi;
                        } else if (n == 4) {
                            --mi;
                            --mj;
                        }
                        if (n != 0) {
                            this.gameData[mi][mj + 1] = 0;
                            this.gameData[mi + 1][mj] = 0;
                            this.gameData[mi + 1][mj + 1] = 0;
                        }
                        vector.addElement(new Integer(mi));
                        vector.addElement(new Integer(mj));
                        vector.addElement(new Integer(this.gameData[mi][mj]));
                        this.gameData[mi][mj] = 0;
                    }
                }
                ++p;
            }
            ++k;
        }
        if (vector.size() > 0) {
            Effectelement e = new Effectelement(vector, 3);
            this.v_Effect.addElement(e);
        }
        this.gameData[i][j] = 0;
        vector = null;
    }

    public void chongEffect(int i, int j) {
        int maxi = this.getMaxi();
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(new Integer(i));
        vector.addElement(new Integer(j));
        vector.addElement(new Integer(maxi - i));
        if (vector.size() > 0) {
            Effectelement e = new Effectelement(vector, 2);
            this.v_Effect.addElement(e);
        }
        this.gameData[i][j] = 0;
        vector = null;
    }

    private void drawLine(Graphics g, int x, int y) {
        int n = this.v_LinkData.size();
        if (n > 0) {
            g.setColor(0xFF0000);
            int i = 0;
            while (i < n) {
                int[][] link = (int[][])this.v_LinkData.elementAt(i);
                int k = 1;
                while (k < link.length) {
                    int x1 = x + link[k - 1][1] * this.elementGridW + this.elementGridW / 2;
                    int y1 = y + (link[k - 1][0] - this.selectBuoy) * this.elementGridH + this.elementGridH / 2;
                    int x2 = x + link[k][1] * this.elementGridW + this.elementGridW / 2;
                    int y2 = y + (link[k][0] - this.selectBuoy) * this.elementGridH + this.elementGridH / 2;
                    if (x1 == x2 && y1 != y2) {
                        if (y2 > y1) {
                            this.drawLink(g, x1, y1, link[k][0] - link[k - 1][0], true);
                        } else {
                            this.drawLink(g, x2, y2, link[k - 1][0] - link[k][0], true);
                        }
                    } else if (x1 != x2 && y1 == y2) {
                        if (x2 > x1) {
                            this.drawLink(g, x1, y1, link[k][1] - link[k - 1][1], false);
                        } else {
                            this.drawLink(g, x2, y2, link[k - 1][1] - link[k][1], false);
                        }
                    }
                    ++k;
                }
                ++i;
            }
            this.linkn = this.linkn == 0 ? 1 : 0;
        }
    }

    private void drawLink(Graphics g, int x, int y, int n, boolean isHS) {
        if (isHS) {
            x -= this.linkH >> 1;
            int i = 0;
            while (i < n) {
                g.setClip(x, y + i * this.elementGridH, this.linkH, this.linkW);
                g.drawImage(this.linkImg[1], x - this.linkn * this.linkH, y + i * this.elementGridH, 0);
                ++i;
            }
        } else {
            y -= this.linkH >> 1;
            int i = 0;
            while (i < n) {
                g.setClip(x + i * this.elementGridW, y, this.linkW, this.linkH);
                g.drawImage(this.linkImg[0], x + i * this.elementGridW, y - this.linkn * this.linkH, 0);
                ++i;
            }
        }
    }

    private void drawTimes(Graphics g, int x, int y, int w, int h) {
        int t = 0;
        y += h - this.scoreH >> 1;
        w = this.scoreW;
        h = this.scoreH;
        t = this.totalTime % 6000 / 600;
        g.setClip(x, y, w, h);
        g.drawImage(this.scoreNoImg, x - t * w, y, 0);
        t = this.totalTime % 600 / 60;
        g.setClip(x += w, y, w, h);
        g.drawImage(this.scoreNoImg, x - t * w, y, 0);
        g.setClip(x += w, y, w, h);
        g.drawImage(this.scoreNoImg, x - 10 * w, y, 0);
        t = this.totalTime % 60 / 10;
        g.setClip(x += w, y, w, h);
        g.drawImage(this.scoreNoImg, x - t * w, y, 0);
        t = this.totalTime % 10;
        g.setClip(x += w, y, w, h);
        g.drawImage(this.scoreNoImg, x - t * w, y, 0);
        MainCanvas.setClipFullScreen(g);
    }

    private void drawTimeOut(Graphics g) {
        MainCanvas.setClipFullScreen(g);
        this.drawScoreBoard(g, false);
        MainCanvas.menu.drawSoftkey(g, 0, 1);
        MainCanvas.menu.drawSoftkey(g, 1, 3);
    }

    private void drawWining(Graphics g) {
    }

    private void drawIsWin(Graphics g) {
        MainCanvas.setClipFullScreen(g);
        this.drawScoreBoard(g, true);
        MainCanvas.setClipFullScreen(g);
        MainCanvas.menu.drawSoftkey(g, 0, 1);
        MainCanvas.menu.drawSoftkey(g, 1, 2);
    }

    private void drawScoreBoard(Graphics g, boolean iswin) {
        int yy;
        int xx;
        if (!iswin) {
            int xx2 = Set.width - this.gameOverWordImg.getWidth() >> 1;
            int yy2 = Set.height - this.gameOverWordImg.getHeight() >> 1;
            g.drawImage(this.gameOverWordImg, xx2, yy2, 0);
            return;
        }
        int w = this.scoreBackImg.getWidth();
        int h = this.scoreBackImg.getHeight();
        int x = Set.width - w >> 1;
        int y = Set.height - h >> 1;
        int y1 = Set.height - h >> 1;
        int starX = x + w / 8;
        g.drawImage(this.scoreBackImg, x, y, 0);
        y += h / 7 >> 1;
        h = h * 6 / 7;
        h >>= 2;
        if (this.stageNo == MainCanvas.menu.bm.allLevelNo) {
            xx = x + (w - this.levelCompleteImg.getWidth() >> 1);
            yy = y1 + this.levelImg.getHeight() * 3 / 4 + SetValues.levelYOff;
            g.drawImage(this.levelCompleteImg, xx, yy, 0);
        } else {
            xx = Set.width / 2 - this.scoreBackImg.getWidth() / 4 + (this.scoreBackImg.getWidth() / 2 - (this.levelImg.getWidth() + this.levelNoW * 2)) / 3 + SetValues.levelXOff;
            yy = y1 + this.levelImg.getHeight() * 3 / 4 + SetValues.levelYOff;
            g.drawImage(this.levelImg, xx, yy, 0);
            int stagenum = Integer.parseInt(this.stageNOstr);
            xx = stagenum > 9 ? (xx += this.levelImg.getWidth()) : (xx += this.levelImg.getWidth() + this.levelNoW);
            this.drawScore(g, xx, yy += this.levelImg.getHeight() - this.levelNoH >> 1, this.stageNOstr, 1, this.levelNoW, this.levelNoH, this.levelNoImg);
        }
        int width = this.scoreWordImg.getWidth();
        int height = this.scoreWordImg.getHeight() / 4;
        xx = (x += SetValues.boroadXParm) + w / 10;
        yy = (y += h + height) + (h / 2 - height >> 1) + SetValues.scoreallYOff;
        g.setClip(xx, yy, width, height);
        g.drawImage(this.scoreWordImg, xx, yy, 0);
        if (this.totalScoreStr != null) {
            this.drawScore(g, xx + width * 1 / 3 + this.scoreW * 2 + SetValues.scoreXOff, yy + (height - this.scoreH >> 1), this.totalScoreStr, 1, this.scoreW, this.scoreH, this.scoreNoImg);
        }
        g.setClip(xx, yy += h >> 1, width, height);
        g.drawImage(this.scoreWordImg, xx, yy - height, 0);
        if (this.timeStr != null) {
            this.drawScore(g, xx + width * 1 / 3 + this.scoreW * 3 / 2 + SetValues.timeXOff, yy + (height - this.scoreH >> 1), this.timeStr, 1, this.scoreW, this.scoreH, this.scoreNoImg);
        }
        g.setClip(xx, yy += h >> 1, width, height);
        g.drawImage(this.scoreWordImg, xx, yy - 2 * height, 0);
        if (this.alltotalScoreStr != null) {
            this.drawScore(g, xx + width * 1 / 3 + this.scoreW * 3 / 2 + SetValues.totalXOff, yy + (height - this.scoreH >> 1), this.alltotalScoreStr, 1, this.scoreW, this.scoreH, this.scoreNoImg);
        }
        g.setClip(xx, yy += h >> 1, width, height);
        g.drawImage(this.scoreWordImg, xx, yy - 3 * height, 0);
        if (this.highScoreStr != null) {
            this.drawScore(g, xx + width * 2 / 3 + 3 * this.scoreW + SetValues.highScoreXOff, yy + (height - this.scoreH >> 1), this.highScoreStr, 1, this.scoreW, this.scoreH, this.scoreNoImg);
        }
        width = this.scoreStarImg.getWidth();
        height = this.scoreStarImg.getHeight() / 2;
        int woff = ((w >>= 2) * 3 - width * 3) / 4;
        xx = starX + woff;
        yy += h / 3;
        int i = 0;
        while (i < 3) {
            g.setClip(xx + i * (width + woff), yy, width, height);
            g.drawImage(this.scoreStarImg, xx + i * (width + woff), yy - height, 0);
            if (i < this.scoreStarNo) {
                g.setClip(xx + i * (width + woff), yy, width, height);
                g.drawImage(this.scoreStarImg, xx + i * (width + woff), yy + 1, 0);
            }
            ++i;
        }
    }

    private void comboTime(int i, int j) {
        this.comboPositionX = this.startx + this.elementGridW * j;
        this.comboPositionY = this.starty + this.elementGridH * i;
        this.comboTimeTo = 1;
        this.comboPositionS = 0;
        this.comboA = (byte)2;
        this.comboPositionV = (int)Math.sqrt(2 * this.comboA * this.elementGridH * 4);
    }

    private void drawComBox(Graphics g) {
        if (this.comboTimeTo == 0 || this.comboxStr == null) {
            return;
        }
        MainCanvas.setClipFullScreen(g);
        this.comboTimeTo = (byte)(this.comboTimeTo + 1);
        int comboT = 1;
        this.comboPositionS -= this.comboPositionV * comboT - this.comboA * comboT * comboT / 2;
        this.comboPositionV -= this.comboA * comboT;
        int x = this.comboPositionX + (this.elementGridW - this.comboImg.getWidth() - this.comboXImg.getWidth() - this.comboxNoW * this.comboxStr.length() >> 1);
        int y = this.comboPositionY + this.comboPositionS;
        if (Set.width - x < this.comboImg.getWidth() + this.comboXImg.getWidth() + this.comboxNoW * this.comboxStr.length()) {
            x = Set.width - (this.comboImg.getWidth() + this.comboXImg.getWidth() + this.comboxNoW * this.comboxStr.length());
        } else if (x < 0) {
            x = 0;
        }
        if (this.comboPositionV < 0) {
            this.comboPositionV = 0;
            this.comboA = 0;
        }
        if (y < this.starty) {
            y = this.starty;
        }
        if (this.comboTimeTo > this.secondTimes * 2) {
            this.comboTimeTo = 0;
        }
        if (this.changTime > 0L) {
            int temp = this.comboImg.getWidth() + this.comboXImg.getWidth() + this.scoreW * this.comboxStr.length() - this.superCombo.getWidth() >> 1;
            if (x + temp < 0) {
                x = -temp;
            } else if (x + temp + this.superCombo.getWidth() > Set.width) {
                x = Set.width - temp - this.superCombo.getWidth();
            }
            if (System.currentTimeMillis() - this.changTime > (long)((this.changTimeParam - 20) * 100)) {
                long l = System.currentTimeMillis() - this.changTime - (long)((this.changTimeParam - 20) * 100);
                if (l > 1800L && l < 2000L || l > 1200L && l < 1500L || l > 600L && l < 900L || l > 0L && l < 300L) {
                    g.drawImage(this.superCombo, x + temp, y - this.superCombo.getHeight(), 0);
                }
            } else {
                g.drawImage(this.superCombo, x + temp, y - this.superCombo.getHeight(), 0);
            }
        }
        g.drawImage(this.comboImg, x, y, 0);
        g.drawImage(this.comboXImg, x += this.comboImg.getWidth(), y += this.comboImg.getHeight() - this.comboXImg.getHeight() >> 1, 0);
        this.drawScore(g, x += this.comboXImg.getWidth(), y += this.comboXImg.getHeight() - this.comboxNoH >> 1, this.comboxStr, 1, this.comboxNoW, this.comboxNoH, this.comboxNoImg);
    }

    public void drawScore(Graphics g, int x, int y, String score, int type, int scoreW, int scoreH, Image scoreImg) {
        if (score == null) {
            return;
        }
        if (type == 2) {
            x -= scoreW * score.length() >> 1;
            y -= scoreH >> 1;
        } else if (type == 3) {
            x -= scoreW * score.length();
        }
        int i = 0;
        while (i < score.length()) {
            char c = score.charAt(i);
            g.setClip(x + i * scoreW, y, scoreW, scoreH);
            if (c == '+') {
                g.drawImage(scoreImg, x - 10 * scoreW, y, 0);
            } else if (c == ':') {
                g.drawImage(scoreImg, x - 10 * scoreW, y, 0);
            } else {
                g.drawImage(scoreImg, x + i * scoreW - (c - 48) * scoreW, y, 0);
            }
            ++i;
        }
        MainCanvas.setClipFullScreen(g);
    }

    public void setScore(int x, int y, int score) {
        this.totalScore += score;
        this.tempScore += score;
        int[] nArray = new int[3];
        nArray[0] = x + (this.elementGridW >> 1);
        nArray[1] = y + (this.elementGridH >> 1);
        int[] s = nArray;
        this.v_score.addElement(s);
        this.v_score.addElement("+" + score);
    }

    public void logic() {
        switch (this.gameState) {
            case 3: {
                break;
            }
            case 1: {
                this.logicStart();
                break;
            }
            case 4: {
                this.logicScore();
                ++this.startTime;
                if (this.startTime > 5 && this.v_Effect.size() == 0 && this.v_star.size() == 0 && this.tempScore == 0) {
                    this.startTime = 0;
                    this.gameState = (byte)5;
                    this.timeStr = String.valueOf(this.timeScore);
                    this.winAndSave();
                }
                this.logicVector();
                break;
            }
            case 5: {
                this.logictotalScore();
                break;
            }
            case 0: {
                this.logicTimes();
                this.logicGame();
                this.logicVector();
                this.logicScore();
                if (this.gamingkey == 1000) break;
                this.gamingkeyPressed(this.gamingkey);
                break;
            }
            case 6: {
                break;
            }
        }
    }

    private void logicVector() {
        int i = 0;
        while (i < this.v_selectData.size()) {
            int[] s = (int[])this.v_selectData.elementAt(i);
            s[2] = s[2] + 1;
            if (s[2] > this.twoBatterTimeParam * this.secondTimes / 10) {
                this.v_selectData.removeElementAt(i);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.v_LinkData.size()) {
            int[][] ss = (int[][])this.v_LinkData.elementAt(i2);
            int[] nArray = ss[0];
            nArray[2] = nArray[2] + 1;
            if (ss[0][2] > 1 * this.secondTimes) {
                this.v_LinkData.removeElementAt(i2);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.v_Effect.size()) {
            if (((Effectelement)this.v_Effect.elementAt(i2)).logic()) {
                this.v_Effect.removeElementAt(i2);
                --i2;
                this.ischeckfly = true;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.v_star.size()) {
            if (((Star)this.v_star.elementAt(i2)).logic()) {
                this.v_star.removeElementAt(i2);
                --i2;
            }
            ++i2;
        }
    }

    private void winAndSave() {
        int[] data;
        Vector<Object> v = new Vector<Object>();
        if (this.bm.rms == null) {
            this.bm.rms = new IECRecordStore();
        }
        if (this.totalScore + this.timeScore > (data = this.bm.rms.readIntArray(SetValues.Rms_name, this.stageNo, 2))[1]) {
            v.addElement(new Integer(this.stageNo));
            data = (int[])this.bm.totalLevel.elementAt(this.stageNo - 1);
            data[0] = this.getscoreStarNo(this.totalScore + this.timeScore);
            this.highScoreStr = data[1] == 0 ? null : String.valueOf(this.totalScore + this.timeScore);
            data[1] = this.totalScore + this.timeScore;
            v.addElement(data);
        } else {
            this.highScoreStr = String.valueOf(data[1]);
        }
        if (this.stageNo >= this.bm.level && this.stageNo != this.bm.allLevelNo) {
            ++this.bm.level;
            data = new int[2];
            v.addElement(new Integer(this.stageNo + 1));
            v.addElement(data);
            this.bm.totalLevel.addElement(data);
            int i = this.stageNo / this.bm.level_horizontal_no;
            int j = this.stageNo % this.bm.level_horizontal_no;
            this.bm.menuLevel[i][j] = String.valueOf(this.bm.level);
        }
        if (v.size() > 0) {
            this.bm.setRms(v);
        }
    }

    private void logicScore() {
        if (this.tempScore >= 1000) {
            this.tempScore -= 1000;
            this.totalScoreStr = String.valueOf(Integer.parseInt(this.totalScoreStr) + 1000);
        } else if (this.tempScore < 1000 && this.tempScore >= 100) {
            this.tempScore -= 100;
            this.totalScoreStr = String.valueOf(Integer.parseInt(this.totalScoreStr) + 100);
        } else if (this.tempScore < 100 && this.tempScore >= 10) {
            this.tempScore -= 10;
            this.totalScoreStr = String.valueOf(Integer.parseInt(this.totalScoreStr) + 10);
        } else if (this.tempScore < 10 && this.tempScore > 0) {
            --this.tempScore;
            this.totalScoreStr = String.valueOf(Integer.parseInt(this.totalScoreStr) + 1);
        }
    }

    private void logicStart() {
        ++this.startTime;
        if (this.startTime > this.secondTimes * 3 / 2) {
            this.startStep += 10;
        }
        if (this.startStep > Set.height * 2 / 5) {
            this.startTime = 0;
            this.startStep = 0;
            this.gameState = 0;
            this.gameStartTime = this.upTime = System.currentTimeMillis();
            this.canStopTime = this.upTime;
            this.effectTime = System.currentTimeMillis() + 2000L;
        }
    }

    private void logicTimes() {
        ++this.currentTimeStep;
        this.totalTime = (int)((System.currentTimeMillis() - this.gameStartTime) / 1000L);
    }

    public void logictotalScore() {
        int allScore;
        int m = 0;
        int n = 0;
        Random r = new Random();
        if (this.iskuaisudaoshu) {
            if (this.totalScore <= 0 && this.timeScore <= 0) {
                this.iskuaisudaoshu = false;
                return;
            }
            allScore = Integer.parseInt(this.alltotalScoreStr);
            allScore = allScore + this.totalScore + this.timeScore;
            this.alltotalScoreStr = String.valueOf(allScore);
            this.totalScore = 0;
            this.timeScore = 0;
            this.totalScoreStr = String.valueOf(n);
            this.timeStr = String.valueOf(n);
        } else if (this.totalScore > 0) {
            m = this.get10(this.totalScoreStr.length());
            this.totalScore -= m;
            n = m >= 10 ? this.totalScore - r.nextInt(m / 10) : this.totalScore;
            if (n < 0) {
                n = 0;
            }
            this.totalScoreStr = String.valueOf(n);
        } else if (this.timeScore > 0) {
            m = this.get10(this.timeStr.length());
            this.timeScore -= m;
            n = m >= 10 ? this.timeScore - r.nextInt(m / 10) : this.timeScore;
            if (n < 0) {
                n = 0;
            }
            this.timeStr = String.valueOf(n);
        } else {
            if (this.highScoreStr == null) {
                this.highScoreStr = this.alltotalScoreStr;
            }
            if (this.scoreStarNo >= (n = this.getscoreStarNo(Integer.parseInt(this.alltotalScoreStr)))) {
                return;
            }
            ++this.startTime;
            if (this.startTime >= this.secondTimes * 4 / 5 && this.startTime < 2 * this.secondTimes * 4 / 5) {
                if (n >= 1) {
                    this.scoreStarNo = 1;
                }
            } else if (this.startTime >= 2 * this.secondTimes * 4 / 5 && this.startTime < 3 * this.secondTimes * 4 / 5) {
                if (n >= 2) {
                    this.scoreStarNo = (byte)2;
                }
            } else if (this.startTime >= 3 * this.secondTimes * 4 / 5 && n >= 3) {
                this.scoreStarNo = (byte)3;
            }
            return;
        }
        allScore = Integer.parseInt(this.alltotalScoreStr);
        this.alltotalScoreStr = String.valueOf(allScore += m);
    }

    private int getscoreStarNo(int allscore) {
        if (allscore >= 2000 && allscore < 8000) {
            return 1;
        }
        if (allscore >= 8000 && allscore < 15000) {
            return 2;
        }
        if (allscore >= 15000) {
            return 3;
        }
        return 0;
    }

    private int get10(int n) {
        int m = 1;
        int i = 1;
        while (i < n) {
            m *= 10;
            ++i;
        }
        return m;
    }

    private void logicGame() {
        if (this.ischeckflyTime != 0L && System.currentTimeMillis() - this.ischeckflyTime > 1000L) {
            this.ischeckfly = true;
            this.ischeckflyTime = 0L;
        }
        if (this.twoBatterTime != 0L && System.currentTimeMillis() - this.twoBatterTime > (long)(this.twoBatterTimeParam * 100)) {
            this.ischeckfly = true;
            this.twoBatterTime = 0L;
        }
        if (this.changTime != 0L && System.currentTimeMillis() - this.changTime > (long)(this.changTimeParam * 100)) {
            this.changTime = 0L;
            this.changData(false, 0);
        }
        if (System.currentTimeMillis() - this.effectTime > (long)(this.effectTimeParam * 2 * 1000)) {
            this.setRandomPosition(98);
            this.effectTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.canStopTime > 10000L) {
            MainCanvas.menu.gameMenuStatus = 6;
            this.gamingkeyPressed(113);
            this.canStopTime = System.currentTimeMillis();
            return;
        }
        if (System.currentTimeMillis() - this.upTime > (long)(this.upOtherTimeParam * 1000)) {
            this.upHorizontal();
        }
        if (this.upTotalHeight > 0) {
            this.upTotalHeight -= this.upHeightStep;
            if (this.upTotalHeight < 0) {
                this.upTotalHeight = 0;
            }
        } else if (this.upTotalHeight < 0) {
            this.upTotalHeight += this.upHeightStep;
            if (this.upTotalHeight > 0) {
                this.upTotalHeight = 0;
            }
        }
        int i = 0;
        while (i < this.v_explosion.size() / 2) {
            Long l = (Long)this.v_explosion.elementAt(i * 2);
            if (System.currentTimeMillis() - l > (long)(this.explosoinTimeParam * 100)) {
                int[] s = (int[])this.v_explosion.elementAt(i * 2 + 1);
                this.gameData[s[0]][s[1]] = 0;
                this.v_explosion.removeElement(l);
                this.v_explosion.removeElement(s);
                --i;
                this.ischeckfly = true;
            }
            ++i;
        }
        if (this.ischeckfly) {
            this.checkFly();
            this.ischeckfly = false;
        }
        if (this.v_LinkData.size() == 0 && this.selectI + this.selectBuoy >= 0 && this.selectI + this.selectBuoy < this.data_vertical_no && this.selectJ >= 0 && this.selectJ < this.data_horizontal_no && this.gameData[this.selectI + this.selectBuoy][this.selectJ] == 0) {
            this.autoFindSelectData();
        }
        if (this.warnStep > 0) {
            this.warnStep = (byte)(this.warnStep + 1);
            if (this.warnStep > this.warntimeParm * 2) {
                this.warnStep = !this.logicWarn() ? (byte)0 : 1;
            }
        }
    }

    private void checkWin() {
        int maxi = this.getMaxi();
        int select = 0;
        Vector<int[]> v = new Vector<int[]>();
        int i = this.show_vertical_no - 1;
        while (i >= 0) {
            int j = 0;
            while (j < this.data_horizontal_no) {
                select = maxi - (this.show_vertical_no - 1 - i);
                if (select >= 0 && (this.isOnlyElement(select, j) || this.isFourBody(select, j) == 1)) {
                    v.addElement(new int[]{select, j});
                }
                ++j;
            }
            --i;
        }
        select = v.size();
        if (select == 0) {
            this.totalScoreStr = String.valueOf(this.totalScore);
            this.timeScore = (180 - this.totalTime) * 15000 / 180;
            if (this.timeScore < 0) {
                this.timeScore = 0;
            }
            this.gameState = (byte)4;
        } else if (select == 1) {
            int[] p = (int[])v.elementAt(0);
            if (p[0] == this.data_vertical_no - 1) {
                this.gameData[p[0] - 1][p[1]] = this.gameData[p[0]][p[1]] % 50;
            } else if (this.isFourBody(p[0], p[1]) == 1) {
                this.gameData[p[0] - 1][p[1]] = this.gameData[p[0]][p[1]] % 50;
            }
        } else if (select <= 8) {
            int[] p = (int[])v.elementAt(0);
            int data = this.gameData[p[0]][p[1]];
            p = (int[])v.elementAt(1);
            if (this.isFourBody(p[0], p[1]) == 1) {
                this.gameData[p[0]][p[1]] = data % 50;
                this.gameData[p[0]][p[1] + 1] = this.gameData[p[0]][p[1]];
                this.gameData[p[0] + 1][p[1]] = this.gameData[p[0]][p[1]];
                this.gameData[p[0] + 1][p[1] + 1] = this.gameData[p[0]][p[1]];
            } else {
                this.gameData[p[0]][p[1]] = data % 50;
            }
        }
    }

    private void setRandomPosition(int data) {
        int maxi = this.getMaxi();
        int select = 0;
        Vector<int[]> v = new Vector<int[]>();
        int i = this.show_vertical_no - 1;
        while (i >= 0) {
            int j = 0;
            while (j < this.data_horizontal_no) {
                select = maxi - (this.show_vertical_no - 1 - i);
                if (select >= 0 && this.gameData[select][j] == 0 && (select > 0 && this.isHaveElement(select - 1, j) || select < maxi && this.isHaveElement(select + 1, j) || j > 0 && this.isHaveElement(select, j - 1) || j < this.data_horizontal_no - 1 && this.isHaveElement(select, j + 1))) {
                    v.addElement(new int[]{select, j});
                }
                ++j;
            }
            --i;
        }
        if (v.size() > 0) {
            Random r = MainCanvas.menu.getRandom();
            int[] p = (int[])v.elementAt(r.nextInt(v.size()));
            this.gameData[p[0]][p[1]] = data;
            if (data == 98) {
                this.v_explosion.addElement(new Long(System.currentTimeMillis()));
                this.v_explosion.addElement(p);
            }
        }
    }

    private void checkElement() {
        int maxi = this.getMaxi();
        if (maxi - this.selectBuoy < this.show_vertical_no - 1) {
            this.checkWin();
            return;
        }
        int num = 0;
        int select = 0;
        int i = this.show_vertical_no - 1;
        while (i >= 0) {
            int j = 0;
            while (j < this.data_horizontal_no) {
                select = maxi - (this.show_vertical_no - 1 - i);
                if (select >= 0 && this.isHaveElement(select, j) && ++num > 13) {
                    return;
                }
                ++j;
            }
            --i;
        }
        if (num < 12) {
            this.upHorizontal();
        }
    }

    private void upHorizontal() {
        int maxi = this.getMaxi() + 1;
        int up = 1;
        if (maxi < this.data_vertical_no - 1) {
            boolean isHeight = true;
            while (isHeight) {
                boolean have = false;
                int j = 0;
                while (j < this.data_horizontal_no - 1) {
                    if (this.isFourBody(maxi, j) == 1) {
                        have = true;
                        if (up >= 2) {
                            isHeight = false;
                            have = false;
                            this.setFourBody(maxi, j);
                        }
                    }
                    ++j;
                }
                if (have) {
                    ++up;
                    if (++maxi < this.data_vertical_no - 1) continue;
                    isHeight = false;
                    continue;
                }
                isHeight = false;
            }
        }
        this.selectBuoy += up * this.upMuch;
        this.upTotalHeight = up * this.upMuch * this.elementGridH;
        this.selectI -= up * this.upMuch;
        if (this.selectI < 0) {
            this.selectI = 0;
        }
        this.upTime = System.currentTimeMillis();
        if (this.checkGameOver()) {
            this.selectBuoy -= up * this.upMuch;
            this.upTotalHeight = -this.elementGridH / 3;
            this.selectI += up * this.upMuch;
            this.upTime = 0L;
            return;
        }
        if (this.warnStep == 0 && this.logicWarn()) {
            this.warnStep = 1;
            System.out.println("\u8b66\u544a/\u6709\u5371\u9669\u4e86.....................");
            return;
        }
    }

    private boolean logicWarn() {
        int i = 0;
        while (i < 2) {
            int select = this.selectBuoy + i;
            if (select >= 0) {
                int j = 0;
                while (j < this.data_horizontal_no) {
                    if (this.gameData[select][j] > 0) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean checkGameOver() {
        if (this.selectBuoy > 0) {
            int j = 0;
            while (j < this.data_horizontal_no) {
                if (this.isHaveElement(this.selectBuoy - 1, j)) {
                    this.gameState = (byte)6;
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private void checkFly() {
        int j;
        int maxi = this.getMaxi();
        int i = 0;
        while (i < this.checkfly.length) {
            j = 0;
            while (j < this.checkfly[i].length) {
                this.checkfly[i][j] = 0;
                ++j;
            }
            ++i;
        }
        int select = 0;
        j = 0;
        while (j < this.data_horizontal_no) {
            if (this.isHaveElement(maxi, j) && this.checkfly[this.show_vertical_no - 1][j] != 1) {
                this.checkfly[this.show_vertical_no - 1][j] = 1;
                this.checkflyDir((byte)(this.show_vertical_no - 1), (byte)j, (byte)maxi, (byte)j, (byte)maxi);
            }
            ++j;
        }
        Vector<Integer> v = new Vector<Integer>();
        int i2 = this.show_vertical_no - 1;
        while (i2 >= 0) {
            int j2 = 0;
            while (j2 < this.data_horizontal_no) {
                select = maxi - (this.show_vertical_no - 1 - i2);
                if (select >= 0 && this.isHaveElement(select, j2) && this.checkfly[i2][j2] == 0) {
                    if (this.isOnlyElement(select, j2) || this.isFourBody(select, j2) == 1) {
                        v.addElement(new Integer(select));
                        v.addElement(new Integer(j2));
                        v.addElement(new Integer(this.gameData[select][j2]));
                        if (this.isFourBody(select, j2) == 1) {
                            this.gameData[select][j2] = 50;
                            this.setFourBody(select, j2);
                        }
                    }
                    this.gameData[select][j2] = 0;
                }
                ++j2;
            }
            --i2;
        }
        if (v.size() > 0) {
            Effectelement e = new Effectelement(v, 1);
            this.v_Effect.addElement(e);
        }
        this.checkElement();
    }

    private void checkflyDir(byte i, byte j, byte si, byte sj, byte maxi) {
        boolean right;
        boolean left;
        boolean dwon;
        boolean up;
        if (si > 0 && this.isHaveElement(si - 1, sj) && i > 0 && this.checkfly[i - 1][j] != 1) {
            this.checkfly[i - 1][j] = 1;
            up = false;
        } else {
            up = true;
        }
        if (si < maxi && this.isHaveElement(si + 1, sj) && i < this.show_vertical_no - 1 && this.checkfly[i + 1][j] != 1) {
            this.checkfly[i + 1][j] = 1;
            dwon = false;
        } else {
            dwon = true;
        }
        if (sj > 0 && this.isHaveElement(si, sj - 1) && j > 0 && this.checkfly[i][j - 1] != 1) {
            this.checkfly[i][j - 1] = 1;
            left = false;
        } else {
            left = true;
        }
        if (sj < this.data_horizontal_no - 1 && this.isHaveElement(si, sj + 1) && j < this.data_horizontal_no - 1 && this.checkfly[i][j + 1] != 1) {
            this.checkfly[i][j + 1] = 1;
            right = false;
        } else {
            right = true;
        }
        if (!up) {
            this.checkflyDir((byte)(i - 1), j, (byte)(si - 1), sj, maxi);
        }
        if (!dwon) {
            this.checkflyDir((byte)(i + 1), j, (byte)(si + 1), sj, maxi);
        }
        if (!left) {
            this.checkflyDir(i, (byte)(j - 1), si, (byte)(sj - 1), maxi);
        }
        if (!right) {
            this.checkflyDir(i, (byte)(j + 1), si, (byte)(sj + 1), maxi);
        }
    }

    public boolean isHaveElement(int i, int j) {
        return this.gameData[i][j] > 0 && this.gameData[i][j] < 9 || this.isFourBody(i, j) != 0 || this.gameData[i][j] == 98 || this.gameData[i][j] == 99;
    }

    public boolean isOnlyElement(int i, int j) {
        return this.gameData[i][j] > 0 && this.gameData[i][j] < 9;
    }

    public void back() {
        MainCanvas.menu.playMusic(false);
        GameMID.sc.toFromto = (byte)10;
        GameMID.sc.getClass();
        GameMID.sc.status = (byte)12;
    }

    private void gamingkeyPressed(int keyCode) {
        switch (keyCode) {
            case -8: 
            case 53: {
                if (this.v_selectData.size() > 0) {
                    this.selectedI = -1;
                    this.selectedJ = -1;
                    this.v_selectData.removeAllElements();
                }
                this.keyFire();
                break;
            }
            case 2: 
            case 52: {
                --this.selectJ;
                int[] s = this.moveLeft(this.selectJ, this.selectBuoy + this.selectI, this.selectJ + 1);
                if (s != null) {
                    this.selectI = s[0] - this.selectBuoy;
                    this.selectJ = s[1];
                } else {
                    ++this.selectJ;
                }
                this.setSelectPosition(this.selectBuoy, this.selectI, this.selectJ, 52);
                if (this.selectedI == -1 || this.v_selectData.size() == 0) break;
                this.keyFire();
                break;
            }
            case 5: 
            case 54: {
                ++this.selectJ;
                int[] s1 = this.moveRight(this.selectJ, this.selectBuoy + this.selectI, this.selectJ - 1);
                if (s1 != null) {
                    this.selectI = s1[0] - this.selectBuoy;
                    this.selectJ = s1[1];
                } else {
                    --this.selectJ;
                }
                this.setSelectPosition(this.selectBuoy, this.selectI, this.selectJ, 54);
                if (this.selectedI == -1 || this.v_selectData.size() == 0) break;
                this.keyFire();
                break;
            }
            case 1: 
            case 50: {
                int select = this.selectBuoy < 0 ? this.matchVertical(this.selectI + this.selectBuoy, this.selectJ, this.getMaxi(), 0, -1) : this.matchVertical(this.selectI + this.selectBuoy, this.selectJ, this.getMaxi(), this.selectBuoy, -1);
                if (select != -1) {
                    this.selectI = select - this.selectBuoy;
                } else if (this.isFourBody(this.selectI + this.selectBuoy, this.selectJ) == 1) {
                    if (this.selectI + this.selectBuoy != 0) {
                        ++this.selectJ;
                        this.gamingkeyPressed(keyCode);
                    }
                } else if (this.selectI + this.selectBuoy != 0) {
                    int l = this.moveHorizontal(this.selectI + this.selectBuoy - 1, this.selectJ, -1);
                    int r = this.moveHorizontal(this.selectI + this.selectBuoy - 1, this.selectJ, 1);
                    if (l != -1 || r != -1) {
                        if (l != -1 && r == -1) {
                            --this.selectI;
                            this.selectJ = l;
                        } else if (l == -1 && r != -1) {
                            --this.selectI;
                            this.selectJ = r;
                        } else {
                            --this.selectI;
                            this.selectJ = r - this.selectJ > this.selectJ - l ? l : r;
                        }
                    }
                }
                this.setSelectPosition(this.selectBuoy, this.selectI, this.selectJ, 50);
                if (this.selectedI == -1 || this.v_selectData.size() == 0) break;
                this.keyFire();
                break;
            }
            case 6: 
            case 56: {
                int select1 = this.matchVertical(this.selectI + this.selectBuoy, this.selectJ, this.getMaxi(), this.selectBuoy, 1);
                if (select1 != -1) {
                    this.selectI = select1 - this.selectBuoy;
                    this.setSelectPosition(this.selectBuoy, this.selectI, this.selectJ, 56);
                } else if (this.isFourBody(this.selectI + this.selectBuoy, this.selectJ) == 3) {
                    ++this.selectJ;
                    this.gamingkeyPressed(keyCode);
                } else if (this.selectI + this.selectBuoy < this.getMaxi()) {
                    int l = this.moveHorizontal(this.selectI + this.selectBuoy + 1, this.selectJ, -1);
                    int r = this.moveHorizontal(this.selectI + this.selectBuoy + 1, this.selectJ, 1);
                    if (l != -1 || r != -1) {
                        if (l != -1 && r == -1) {
                            ++this.selectI;
                            this.selectJ = l;
                        } else if (l == -1 && r != -1) {
                            ++this.selectI;
                            this.selectJ = r;
                        } else {
                            ++this.selectI;
                            this.selectJ = r - this.selectJ > this.selectJ - l ? l : r;
                        }
                    }
                }
                if (this.selectedI == -1 || this.v_selectData.size() == 0) break;
                this.keyFire();
                break;
            }
            case 113: {
                if (MainCanvas.menu.gameMenuStatus == 4) {
                    MainCanvas.menu.setGameMenuStatus(8);
                    break;
                }
                if (MainCanvas.menu.gameMenuStatus == 5) {
                    MainCanvas.menu.setGameMenuStatus(6);
                    break;
                }
                this.gameState = (byte)3;
                this.stoptime = System.currentTimeMillis();
                MainCanvas.menu.setGameMenuStatus(7);
                MainCanvas.menu.playMusic(false);
                break;
            }
        }
        this.gamingkey = 1000;
    }

    public void keyPressed(int keyCode) {
        this.canStopTime = System.currentTimeMillis();
        if (this.gameState == 0) {
            this.gamingkey = keyCode;
        } else if (this.gameState == 6 || this.gameState == 5) {
            switch (keyCode) {
                case 113: {
                    this.back();
                    break;
                }
                case 112: {
                    if (this.gameState == 5) {
                        ++this.stageNo;
                        this.stageNOstr = String.valueOf(this.stageNo);
                        if (this.stageNo > this.bm.allLevelNo) {
                            this.back();
                            return;
                        }
                    }
                    this.restart();
                    break;
                }
                default: {
                    this.iskuaisudaoshu = true;
                    break;
                }
            }
        } else if (this.gameState == 3) {
            switch (keyCode) {
                case -8: 
                case 53: {
                    switch (this.selectStopMenu) {
                        case 0: {
                            this.restart();
                            break;
                        }
                        case 1: {
                            this.stopToSettingOrHelp = true;
                            MainCanvas.menu.musicsRecord = MainCanvas.menu.musicSet;
                            MainCanvas.menu.loadRes(4);
                            GameMID.sc.getClass();
                            GameMID.sc.status = 0;
                            MainCanvas.menu.getClass();
                            MainCanvas.menu.status = 2;
                            break;
                        }
                        case 2: {
                            this.stopToSettingOrHelp = true;
                            SetLanguage s = new SetLanguage();
                            MainCanvas.menu.helpT = new DragText(s.helpStr, MainCanvas.menu.kuang_x + (SetValues.kuang_bian >> 1), MainCanvas.menu.kuang_y + (SetValues.kuang_bian >> 1) + SetValues.textY, Set.width * 2 / 3 + SetValues.textWOff, Set.height * 7 / 10 + SetValues.textHOff, Menu.f);
                            s = null;
                            GameMID.sc.getClass();
                            GameMID.sc.status = 0;
                            MainCanvas.menu.getClass();
                            MainCanvas.menu.status = 3;
                            break;
                        }
                        case 3: {
                            this.back();
                        }
                    }
                    break;
                }
                case 1: 
                case 50: {
                    --this.selectStopMenu;
                    if (this.selectStopMenu >= 0) break;
                    this.selectStopMenu = 3;
                    break;
                }
                case 6: 
                case 56: {
                    ++this.selectStopMenu;
                    if (this.selectStopMenu <= 3) break;
                    this.selectStopMenu = 0;
                    break;
                }
                case 113: {
                    this.canStopTime = System.currentTimeMillis();
                    long time = this.canStopTime - this.stoptime;
                    if (this.stoptime == 0L) {
                        time = 0L;
                    }
                    if (this.twoBatterTime != 0L) {
                        this.twoBatterTime += time;
                    }
                    if (this.upTime != 0L) {
                        this.upTime += time;
                    }
                    if (this.ischeckflyTime != 0L) {
                        this.ischeckflyTime += time;
                    }
                    if (this.effectTime != 0L) {
                        this.effectTime += time;
                    }
                    if (this.changTime != 0L) {
                        this.changTime += time;
                    }
                    this.gameStartTime += time;
                    if (this.ofish != null) {
                        this.ofish.currentTime += time;
                    }
                    int i = 0;
                    while (i < this.v_explosion.size() / 2) {
                        Long l = (Long)this.v_explosion.elementAt(i * 2);
                        l = new Long(l + time);
                        this.v_explosion.removeElementAt(i * 2);
                        this.v_explosion.insertElementAt(l, i * 2);
                        ++i;
                    }
                    this.gameState = 0;
                    MainCanvas.menu.playMusic(true);
                }
            }
        }
    }

    private void setSelectPosition(int selectBuoy, int selectI, int selectJ, int keyCode) {
        int n = this.isFourBody(selectI + selectBuoy, selectJ);
        if (n != 0) {
            switch (n) {
                case 2: {
                    if (keyCode == 54) {
                        this.gamingkeyPressed(keyCode);
                        break;
                    }
                    this.selectJ = selectJ - 1;
                    break;
                }
                case 3: {
                    if (keyCode == 56) {
                        this.gamingkeyPressed(keyCode);
                        break;
                    }
                    this.selectI = selectI - 1;
                    break;
                }
                case 4: {
                    this.selectI = selectI - 1;
                    this.selectJ = selectJ - 1;
                }
            }
        }
    }

    public int moveHorizontal(int i, int j, int dir) {
        if ((j += dir) < 0 || j >= this.data_horizontal_no) {
            return -1;
        }
        if (dir == 1) {
            int k = 0;
            while (k < this.data_horizontal_no - j) {
                if (this.isOnlyElement(i, j + k) || this.isFourBody(i, j + k) != 0) {
                    return j + k;
                }
                ++k;
            }
        } else {
            int k = 0;
            while (k < j + 1) {
                if (this.isOnlyElement(i, j - k) || this.isFourBody(i, j - k) != 0) {
                    return j - k;
                }
                ++k;
            }
        }
        return -1;
    }

    public int[] moveLeft(int j, int startI, int startJ) {
        int s = this.moveHorizontal(startI, startJ, -1);
        if (s != -1) {
            return new int[]{startI, s};
        }
        int mini = this.selectBuoy;
        if (mini < 0) {
            mini = 0;
        }
        int maxi = this.getMaxi();
        int i = 0;
        while (i < this.data_horizontal_no) {
            s = j - i;
            if (s < 0) {
                s += this.data_horizontal_no;
            }
            int k = 0;
            while (k < startI - mini + 1) {
                if (this.isOnlyElement(startI - k, s) || this.isFourBody(startI - k, s) != 0) {
                    return new int[]{startI - k, s};
                }
                ++k;
            }
            k = 0;
            while (k < maxi - startI) {
                if (this.isOnlyElement(startI + k + 1, s) || this.isFourBody(startI + k + 1, s) != 0) {
                    return new int[]{startI + k + 1, s};
                }
                ++k;
            }
            ++i;
        }
        return null;
    }

    public int[] moveRight(int j, int startI, int startJ) {
        int s = this.moveHorizontal(startI, startJ, 1);
        if (s != -1) {
            return new int[]{startI, s};
        }
        int mini = this.selectBuoy;
        if (mini < 0) {
            mini = 0;
        }
        int maxi = this.getMaxi();
        int i = 0;
        while (i < this.data_horizontal_no) {
            s = j + i;
            if (s >= this.data_horizontal_no) {
                s -= this.data_horizontal_no;
            }
            int k = 0;
            while (k < startI - mini + 1) {
                if (this.isOnlyElement(startI - k, s) || this.isFourBody(startI - k, s) != 0) {
                    return new int[]{startI - k, s};
                }
                ++k;
            }
            k = 0;
            while (k < maxi - startI) {
                if (this.isOnlyElement(startI + k + 1, s) || this.isFourBody(startI + k + 1, s) != 0) {
                    return new int[]{startI + k + 1, s};
                }
                ++k;
            }
            ++i;
        }
        return null;
    }

    public int matchVertical(int i, int j, int maxi, int mini, int select) {
        if ((i += select) > maxi || i < mini) {
            return -1;
        }
        if (select == 1) {
            int k = 0;
            while (k < maxi - i + 1) {
                if (this.isOnlyElement(i + k, j) || this.isFourBody(i + k, j) != 0) {
                    return i + k;
                }
                ++k;
            }
            return -1;
        }
        int k = 0;
        while (k < i - mini + 1) {
            if (this.isOnlyElement(i - k, j) || this.isFourBody(i - k, j) != 0) {
                return i - k;
            }
            ++k;
        }
        return -1;
    }

    private void autoFindSelectData() {
        if (this.gameData[this.selectI + this.selectBuoy][this.selectJ] > 0) {
            return;
        }
        this.gamingkeyPressed(1);
        if (this.gameData[this.selectI + this.selectBuoy][this.selectJ] > 0) {
            return;
        }
        this.gamingkeyPressed(2);
        if (this.gameData[this.selectI + this.selectBuoy][this.selectJ] > 0) {
            return;
        }
        this.gamingkeyPressed(6);
        if (this.gameData[this.selectI + this.selectBuoy][this.selectJ] <= 0) {
            this.gamingkeyPressed(5);
        }
    }

    private void keyFire() {
        block19: {
            int myselectI;
            block20: {
                block21: {
                    block18: {
                        myselectI = this.selectBuoy + this.selectI;
                        if (myselectI < 0 || myselectI >= this.data_vertical_no) {
                            return;
                        }
                        if (this.selectedI != -1) break block18;
                        if (this.isOnlyElement(myselectI, this.selectJ) || this.isFourBody(myselectI, this.selectJ) == 1) {
                            this.selectedI = myselectI;
                            this.selectedJ = this.selectJ;
                            this.score = 0;
                        }
                        break block19;
                    }
                    if (this.v_selectData.size() != 0) break block20;
                    if (!this.isOnlyElement(myselectI, this.selectJ) && this.isFourBody(myselectI, this.selectJ) != 1 || this.selectedI == myselectI && this.selectedJ == this.selectJ) break block21;
                    if (this.toCheckLink(this.selectedI, this.selectedJ, myselectI, this.selectJ, true)) {
                        int d;
                        this.score = (this.totalTimeStep - this.currentTimeStep) * 100 / this.totalTimeStep;
                        if (this.score < 10) {
                            this.score = 10;
                        }
                        if (this.isFourBody(this.selectedI, this.selectedJ) == 1) {
                            d = -this.gameData[this.selectedI][this.selectedJ];
                            this.gameData[this.selectedI][this.selectedJ] = 50;
                            this.setFourBody(this.selectedI, this.selectedJ);
                            this.gameData[this.selectedI][this.selectedJ] = d;
                            this.score += this.score / 10;
                            this.setScore(this.startx + this.selectedJ * this.elementGridW, this.starty + (this.selectedI - this.selectBuoy) * this.elementGridH, this.score);
                        } else {
                            this.gameData[this.selectedI][this.selectedJ] = -this.gameData[this.selectedI][this.selectedJ];
                            this.setScore(this.startx + this.selectedJ * this.elementGridW, this.starty + (this.selectedI - this.selectBuoy) * this.elementGridH, this.score);
                        }
                        if (this.isFourBody(myselectI, this.selectJ) == 1) {
                            d = -this.gameData[myselectI][this.selectJ];
                            this.gameData[myselectI][this.selectJ] = 50;
                            this.setFourBody(myselectI, this.selectJ);
                            this.gameData[myselectI][this.selectJ] = d;
                            this.score += this.score / 10;
                            this.setScore(this.startx + this.selectJ * this.elementGridW, this.starty + this.selectI * this.elementGridH, this.score);
                        } else {
                            this.gameData[myselectI][this.selectJ] = -this.gameData[myselectI][this.selectJ];
                            this.setScore(this.startx + this.selectJ * this.elementGridW, this.starty + this.selectI * this.elementGridH, this.score);
                        }
                        this.currentTimeStep = 0;
                        this.batterTimes = 0;
                        this.twoBatterTime = System.currentTimeMillis();
                        this.ischeckflyTime = System.currentTimeMillis();
                        this.checkElement();
                    } else {
                        this.selectedI = myselectI;
                        this.selectedJ = this.selectJ;
                    }
                    break block19;
                }
                if (this.selectedI != myselectI || this.selectedJ != this.selectJ) break block19;
                this.selectedI = -1;
                this.selectedJ = -1;
                break block19;
            }
            if (System.currentTimeMillis() - this.twoBatterTime < (long)(this.twoBatterTimeParam * 100) && (this.isOnlyElement(myselectI, this.selectJ) || this.isFourBody(myselectI, this.selectJ) == 1)) {
                int n;
                int i = n = this.v_selectData.size() - 1;
                while (i >= 0) {
                    int[] s = (int[])this.v_selectData.elementAt(i);
                    if (this.toCheckLink(s[0], s[1], myselectI, this.selectJ, false)) {
                        int data = this.gameData[myselectI][this.selectJ] % 50;
                        if (this.isFourBody(myselectI, this.selectJ) == 1) {
                            int d = -this.gameData[myselectI][this.selectJ];
                            this.gameData[myselectI][this.selectJ] = 50;
                            this.setFourBody(myselectI, this.selectJ);
                            this.gameData[myselectI][this.selectJ] = d;
                            this.score += this.score / 50;
                            if (this.score >= 2000) {
                                this.score = 2000;
                            }
                            this.setScore(this.startx + this.selectJ * this.elementGridW, this.starty + this.selectI * this.elementGridH, this.score);
                        } else {
                            this.score += this.score / 10;
                            if (this.score >= 2000) {
                                this.score = 2000;
                            }
                            this.gameData[myselectI][this.selectJ] = -this.gameData[myselectI][this.selectJ];
                            this.setScore(this.startx + this.selectJ * this.elementGridW, this.starty + this.selectI * this.elementGridH, this.score);
                        }
                        this.batterTimes = (short)(this.batterTimes + 1);
                        this.twoBatterTime = System.currentTimeMillis();
                        this.comboTime(this.selectI, this.selectJ);
                        if (this.ischeckflyTime == 0L) {
                            this.ischeckflyTime = System.currentTimeMillis();
                        }
                        this.comboxStr = String.valueOf(this.batterTimes);
                        this.currentTimeStep = 0;
                        this.checkElement();
                        if (this.changTime == 0L && this.batterTimes >= 4) {
                            this.changData(true, data);
                            break;
                        }
                        if (this.batterTimes != 2) break;
                        this.setRandomPosition(99);
                        break;
                    }
                    --i;
                }
            }
        }
    }

    private boolean toCheckLink(int selectedI, int selectedJ, int selectI, int selectJ, boolean twoOrThree) {
        int data = this.gameData[selectedI][selectedJ];
        if (!twoOrThree && data < 0) {
            data = -data % 100;
        }
        if (this.isFourBody(data) == 1 && this.isFourBody(selectI, selectJ) == 0) {
            boolean ic = this.isConnect(selectedI, selectedJ, selectI, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI, selectedJ + 1, selectI, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI + 1, selectedJ, selectI, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI + 1, selectedJ + 1, selectI, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
        } else if (this.isFourBody(data) == 0 && this.isFourBody(selectI, selectJ) == 1) {
            boolean ic = this.isConnect(selectedI, selectedJ, selectI, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI, selectedJ, selectI, selectJ + 1, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI, selectedJ, selectI + 1, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI, selectedJ, selectI + 1, selectJ + 1, twoOrThree);
            if (ic) {
                return ic;
            }
        } else if (this.isFourBody(data) == 1 && this.isFourBody(selectI, selectJ) == 1) {
            boolean ic = this.isConnect(selectedI, selectedJ, selectI, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI, selectedJ, selectI, selectJ + 1, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI, selectedJ, selectI + 1, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI, selectedJ, selectI + 1, selectJ + 1, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI, selectedJ + 1, selectI, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI, selectedJ + 1, selectI, selectJ + 1, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI, selectedJ + 1, selectI + 1, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI, selectedJ + 1, selectI + 1, selectJ + 1, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI + 1, selectedJ, selectI, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI + 1, selectedJ, selectI, selectJ + 1, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI + 1, selectedJ, selectI + 1, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI + 1, selectedJ, selectI + 1, selectJ + 1, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI + 1, selectedJ + 1, selectI, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI + 1, selectedJ + 1, selectI, selectJ + 1, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI + 1, selectedJ + 1, selectI + 1, selectJ, twoOrThree);
            if (ic) {
                return ic;
            }
            ic = this.isConnect(selectedI + 1, selectedJ + 1, selectI + 1, selectJ + 1, twoOrThree);
            if (ic) {
                return ic;
            }
        } else {
            if (this.isFourBody(data) == 0 && this.isFourBody(selectI, selectJ) == 0) {
                return this.isConnect(selectedI, selectedJ, selectI, selectJ, twoOrThree);
            }
            System.out.println("\u51fa\u73b0\u8fd9\u53e5.\u8bf4\u660e\u5224\u65ad\u662f\u5426\u8fde\u51fb \u8bb0\u5f55\u662f2028\u884c...\u6709\u51fa\u73b0\u9009\u4e2d\u65e0\u662f\u732a\u811a\u7684\u4e86..\u68c0\u67e5\u95ee\u9898..\u60b2\u5267\u4e86\u5509...");
        }
        return false;
    }

    private void changData(boolean chang, int data) {
        if (chang) {
            int maxi = this.getMaxi();
            if (this.selectBuoy < 0) {
                this.changPosition = 0;
                this.recordData = new int[maxi + 1][this.data_horizontal_no];
            } else {
                this.changPosition = this.selectBuoy;
                this.recordData = new int[maxi - this.changPosition + 1][this.data_horizontal_no];
            }
            int i = 0;
            while (i < this.recordData.length) {
                int j = 0;
                while (j < this.recordData[i].length) {
                    if (this.isOnlyElement(this.changPosition + i, j) || this.isFourBody(this.changPosition + i, j) != 0) {
                        this.recordData[i][j] = this.gameData[this.changPosition + i][j];
                        this.gameData[this.changPosition + i][j] = data;
                    } else {
                        this.recordData[i][j] = 0;
                    }
                    ++j;
                }
                ++i;
            }
            this.changTime = System.currentTimeMillis();
        } else {
            int n = 0;
            int i = 0;
            while (i < this.recordData.length) {
                int j = 0;
                while (j < this.recordData[i].length) {
                    if (this.isOnlyElement(this.changPosition + i, j)) {
                        n = this.isFourBody(this.recordData[i][j]);
                        switch (n) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                if (this.isallzai(i, j, n)) {
                                    this.gameData[this.changPosition + i][j] = this.recordData[i][j];
                                    break;
                                }
                                this.gameData[this.changPosition + i][j] = this.recordData[i][j] % 50;
                                break;
                            }
                            case 0: {
                                this.gameData[this.changPosition + i][j] = this.recordData[i][j];
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            this.recordData = null;
        }
    }

    public boolean isallzai(int i, int j, int n) {
        return n == 1 ? this.gameData[i][j + 1] > 0 && this.gameData[i + 1][j + 1] > 0 && this.gameData[i + 1][j] > 0 : (n == 2 ? this.gameData[i][j - 1] > 0 && this.gameData[i + 1][j - 1] > 0 && this.gameData[i + 1][j] > 0 : (n == 3 ? this.gameData[i][j + 1] > 0 && this.gameData[i - 1][j + 1] > 0 && this.gameData[i - 1][j] > 0 : n == 4 && this.gameData[i][j - 1] > 0 && this.gameData[i - 1][j - 1] > 0 && this.gameData[i - 1][j] > 0));
    }

    private boolean isConnect(int i1, int j1, int i2, int j2, boolean isNewOrAdd) {
        if (isNewOrAdd && this.gameData[i1][j1] % 50 != this.gameData[i2][j2] % 50) {
            return false;
        }
        if (!isNewOrAdd && -this.gameData[i1][j1] % 50 != this.gameData[i2][j2] % 50) {
            return false;
        }
        if (j1 == j2 && this.isVertical(i1, i2, j1)) {
            int[][] nArrayArray = new int[2][];
            int[] nArray = new int[3];
            nArray[0] = i1;
            nArray[1] = j1;
            nArrayArray[0] = nArray;
            nArrayArray[1] = new int[]{i2, j2};
            this.linkOneData = nArrayArray;
            this.addData(i1, j1, i2, j2, isNewOrAdd);
            return true;
        }
        if (i1 == i2 && this.isHorizon(i1, j1, j2)) {
            int[][] nArrayArray = new int[2][];
            int[] nArray = new int[3];
            nArray[0] = i1;
            nArray[1] = j1;
            nArrayArray[0] = nArray;
            nArrayArray[1] = new int[]{i2, j2};
            this.linkOneData = nArrayArray;
            this.addData(i1, j1, i2, j2, isNewOrAdd);
            return true;
        }
        if (this.isOneCorner(i1, j1, i2, j2)) {
            this.addData(i1, j1, i2, j2, isNewOrAdd);
            return true;
        }
        if (this.isTwoCorner(i1, j1, i2, j2)) {
            this.addData(i1, j1, i2, j2, isNewOrAdd);
            return true;
        }
        return false;
    }

    private void addData(int i1, int j1, int i2, int j2, boolean isNewOrAdd) {
        this.v_LinkData.addElement(this.linkOneData);
        if (isNewOrAdd) {
            this.addIJ(i1, j1);
            this.addIJ(i2, j2);
        } else {
            this.addIJ(i2, j2);
        }
    }

    public void addIJ(int i, int j) {
        int n = this.isFourBody(i, j);
        if (n == 2) {
            int[] nArray = new int[3];
            nArray[0] = i;
            nArray[1] = j - 1;
            this.v_selectData.addElement(nArray);
        } else if (n == 3) {
            int[] nArray = new int[3];
            nArray[0] = i - 1;
            nArray[1] = j;
            this.v_selectData.addElement(nArray);
        } else if (n == 4) {
            int[] nArray = new int[3];
            nArray[0] = i - 1;
            nArray[1] = j - 1;
            this.v_selectData.addElement(nArray);
        } else {
            int[] nArray = new int[3];
            nArray[0] = i;
            nArray[1] = j;
            this.v_selectData.addElement(nArray);
        }
    }

    private boolean isVertical(int i1, int i2, int j) {
        if (i1 == i2) {
            System.out.println("horizon\u7684\u4e24\u4e2a\u503c\u90fd\u76f8\u7b49\u4e86:");
            return false;
        }
        int i_start = i1 < i2 ? i1 : i2;
        int i_end = i1 < i2 ? i2 : i1;
        int i = i_start + 1;
        while (i < i_end) {
            if (this.gameData[i][j] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isHorizon(int i, int j1, int j2) {
        if (j1 == j2) {
            System.out.println("vertical\u7684\u4e24\u4e2a\u503c\u90fd\u76f8\u7b49\u4e86:");
            return false;
        }
        int j_start = j1 < j2 ? j1 : j2;
        int j_end = j1 < j2 ? j2 : j1;
        int j = j_start + 1;
        while (j < j_end) {
            if (this.gameData[i][j] != 0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private boolean isOneCorner(int i1, int j1, int i2, int j2) {
        if (i1 == i2 && j1 == j2) {
            return false;
        }
        int temp = -1;
        if (i1 > i2) {
            temp = i1;
            i1 = i2;
            i2 = temp;
            temp = j1;
            j1 = j2;
            j2 = temp;
        }
        if (this.gameData[i1][j2] == 0 && this.isHorizon(i1, j1, j2) && this.isVertical(i1, i2, j2)) {
            if (temp == -1) {
                int[][] nArrayArray = new int[3][];
                int[] nArray = new int[3];
                nArray[0] = i1;
                nArray[1] = j1;
                nArrayArray[0] = nArray;
                nArrayArray[1] = new int[]{i1, j2};
                nArrayArray[2] = new int[]{i2, j2};
                this.linkOneData = nArrayArray;
            } else {
                int[][] nArrayArray = new int[3][];
                int[] nArray = new int[3];
                nArray[0] = i2;
                nArray[1] = j2;
                nArrayArray[0] = nArray;
                nArrayArray[1] = new int[]{i1, j2};
                nArrayArray[2] = new int[]{i1, j1};
                this.linkOneData = nArrayArray;
            }
            return true;
        }
        if (this.gameData[i2][j1] == 0 && this.isHorizon(i2, j1, j2) && this.isVertical(i1, i2, j1)) {
            if (temp == -1) {
                int[][] nArrayArray = new int[3][];
                int[] nArray = new int[3];
                nArray[0] = i1;
                nArray[1] = j1;
                nArrayArray[0] = nArray;
                nArrayArray[1] = new int[]{i2, j1};
                nArrayArray[2] = new int[]{i2, j2};
                this.linkOneData = nArrayArray;
            } else {
                int[][] nArrayArray = new int[3][];
                int[] nArray = new int[3];
                nArray[0] = i2;
                nArray[1] = j2;
                nArrayArray[0] = nArray;
                nArrayArray[1] = new int[]{i2, j1};
                nArrayArray[2] = new int[]{i1, j1};
                this.linkOneData = nArrayArray;
            }
            return true;
        }
        return false;
    }

    private boolean isTwoCorner(int i1, int j1, int i2, int j2) {
        int temp = -1;
        if (i1 > i2) {
            temp = i1;
            i1 = i2;
            i2 = temp;
            temp = j1;
            j1 = j2;
            j2 = temp;
        }
        int maxi = this.getMaxi();
        if (j1 != j2) {
            int i = i1 - 1;
            while (i >= -1) {
                if (i == -1) {
                    if (i1 == i2 || this.gameData[0][j2] == 0 && this.isVertical(0, i2, j2)) {
                        if (temp == -1) {
                            int[][] nArrayArray = new int[4][];
                            int[] nArray = new int[3];
                            nArray[0] = i1;
                            nArray[1] = j1;
                            nArrayArray[0] = nArray;
                            nArrayArray[1] = new int[]{-1, j1};
                            nArrayArray[2] = new int[]{-1, j2};
                            nArrayArray[3] = new int[]{i2, j2};
                            this.linkOneData = nArrayArray;
                        } else {
                            int[][] nArrayArray = new int[4][];
                            int[] nArray = new int[3];
                            nArray[0] = i2;
                            nArray[1] = j2;
                            nArrayArray[0] = nArray;
                            nArrayArray[1] = new int[]{-1, j2};
                            nArrayArray[2] = new int[]{-1, j1};
                            nArrayArray[3] = new int[]{i1, j1};
                            this.linkOneData = nArrayArray;
                        }
                        return true;
                    }
                } else {
                    if (this.gameData[i][j1] != 0 || this.gameData[i][j2] != 0 || !this.isVertical(i1, i, j1) || !this.isVertical(i2, i, j2)) break;
                    if (this.isHorizon(i, j1, j2)) {
                        if (temp == -1) {
                            int[][] nArrayArray = new int[4][];
                            int[] nArray = new int[3];
                            nArray[0] = i1;
                            nArray[1] = j1;
                            nArrayArray[0] = nArray;
                            nArrayArray[1] = new int[]{i, j1};
                            nArrayArray[2] = new int[]{i, j2};
                            nArrayArray[3] = new int[]{i2, j2};
                            this.linkOneData = nArrayArray;
                        } else {
                            int[][] nArrayArray = new int[4][];
                            int[] nArray = new int[3];
                            nArray[0] = i2;
                            nArray[1] = j2;
                            nArrayArray[0] = nArray;
                            nArrayArray[1] = new int[]{i, j2};
                            nArrayArray[2] = new int[]{i, j1};
                            nArrayArray[3] = new int[]{i1, j1};
                            this.linkOneData = nArrayArray;
                        }
                        return true;
                    }
                }
                --i;
            }
            i = i1 + 1;
            while (i <= maxi + 1) {
                if (i != i2) {
                    if (i == maxi + 1) {
                        if (maxi + 1 >= this.data_vertical_no && (i1 == i2 || this.gameData[maxi][j1] == 0 && this.isVertical(i1, maxi, j1) && (i2 == maxi || this.gameData[maxi][j2] == 0 && this.isVertical(i2, maxi, j2)))) {
                            if (temp == -1) {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i1;
                                nArray[1] = j1;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{maxi + 1, j1};
                                nArrayArray[2] = new int[]{maxi + 1, j2};
                                nArrayArray[3] = new int[]{i2, j2};
                                this.linkOneData = nArrayArray;
                            } else {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i2;
                                nArray[1] = j2;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{maxi + 1, j2};
                                nArrayArray[2] = new int[]{maxi + 1, j1};
                                nArrayArray[3] = new int[]{i1, j1};
                                this.linkOneData = nArrayArray;
                            }
                            return true;
                        }
                    } else if (this.gameData[i][j1] == 0 && this.gameData[i][j2] == 0 && this.isVertical(i1, i, j1) && this.isVertical(i2, i, j2)) {
                        if (this.isHorizon(i, j1, j2)) {
                            if (temp == -1) {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i1;
                                nArray[1] = j1;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{i, j1};
                                nArrayArray[2] = new int[]{i, j2};
                                nArrayArray[3] = new int[]{i2, j2};
                                this.linkOneData = nArrayArray;
                            } else {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i2;
                                nArray[1] = j2;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{i, j2};
                                nArrayArray[2] = new int[]{i, j1};
                                nArrayArray[3] = new int[]{i1, j1};
                                this.linkOneData = nArrayArray;
                            }
                            return true;
                        }
                    } else if (i > i2) break;
                }
                ++i;
            }
        }
        if (i1 != i2) {
            int j = j1 - 1;
            while (j >= -1) {
                if (j2 != j) {
                    if (j == -1) {
                        if (j1 == j2 || (j2 == 0 || this.gameData[i2][0] == 0 && this.isHorizon(i2, 0, j2)) && (j1 == 0 || this.gameData[i1][0] == 0 && this.isHorizon(i1, 0, j1))) {
                            if (temp == -1) {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i1;
                                nArray[1] = j1;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{i1, -1};
                                nArrayArray[2] = new int[]{i2, -1};
                                nArrayArray[3] = new int[]{i2, j2};
                                this.linkOneData = nArrayArray;
                            } else {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i2;
                                nArray[1] = j2;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{i2, -1};
                                nArrayArray[2] = new int[]{i1, -1};
                                nArrayArray[3] = new int[]{i1, j1};
                                this.linkOneData = nArrayArray;
                            }
                            return true;
                        }
                    } else if (this.gameData[i1][j] == 0 && this.gameData[i2][j] == 0 && this.isHorizon(i1, j1, j) && this.isHorizon(i2, j2, j)) {
                        if (this.isVertical(i1, i2, j)) {
                            if (temp == -1) {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i1;
                                nArray[1] = j1;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{i1, j};
                                nArrayArray[2] = new int[]{i2, j};
                                nArrayArray[3] = new int[]{i2, j2};
                                this.linkOneData = nArrayArray;
                            } else {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i2;
                                nArray[1] = j2;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{i2, j};
                                nArrayArray[2] = new int[]{i1, j};
                                nArrayArray[3] = new int[]{i1, j1};
                                this.linkOneData = nArrayArray;
                            }
                            return true;
                        }
                    } else if (j < j2) break;
                }
                --j;
            }
            j = j1 + 1;
            while (j <= this.data_horizontal_no) {
                if (j2 != j) {
                    if (j == this.data_horizontal_no) {
                        if (j1 == j2 || (j2 == this.data_horizontal_no - 1 || this.gameData[i2][this.data_horizontal_no - 1] == 0 && this.isHorizon(i2, this.data_horizontal_no - 1, j2)) && (j1 == this.data_horizontal_no - 1 || this.gameData[i1][this.data_horizontal_no - 1] == 0 && this.isHorizon(i1, this.data_horizontal_no - 1, j1))) {
                            if (temp == -1) {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i1;
                                nArray[1] = j1;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{i1, this.data_horizontal_no};
                                nArrayArray[2] = new int[]{i2, this.data_horizontal_no};
                                nArrayArray[3] = new int[]{i2, j2};
                                this.linkOneData = nArrayArray;
                            } else {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i2;
                                nArray[1] = j2;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{i2, this.data_horizontal_no};
                                nArrayArray[2] = new int[]{i1, this.data_horizontal_no};
                                nArrayArray[3] = new int[]{i1, j1};
                                this.linkOneData = nArrayArray;
                            }
                            return true;
                        }
                    } else if (this.gameData[i1][j] == 0 && this.gameData[i2][j] == 0 && this.isHorizon(i1, j1, j) && this.isHorizon(i2, j2, j)) {
                        if (this.isVertical(i1, i2, j)) {
                            if (temp == -1) {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i1;
                                nArray[1] = j1;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{i1, j};
                                nArrayArray[2] = new int[]{i2, j};
                                nArrayArray[3] = new int[]{i2, j2};
                                this.linkOneData = nArrayArray;
                            } else {
                                int[][] nArrayArray = new int[4][];
                                int[] nArray = new int[3];
                                nArray[0] = i2;
                                nArray[1] = j2;
                                nArrayArray[0] = nArray;
                                nArrayArray[1] = new int[]{i2, j};
                                nArrayArray[2] = new int[]{i1, j};
                                nArrayArray[3] = new int[]{i1, j1};
                                this.linkOneData = nArrayArray;
                            }
                            return true;
                        }
                    } else if (j > j2) break;
                }
                ++j;
            }
        }
        return false;
    }

    private int getMaxi() {
        int maxi = this.selectBuoy + this.show_vertical_no - 1;
        if (maxi >= this.data_vertical_no) {
            maxi = this.data_vertical_no - 1;
        }
        return maxi;
    }

    public void addStarToElement(int x, int y, boolean isBig) {
        Random r = MainCanvas.menu.getRandom();
        x -= this.elementGridW >> 1;
        y -= this.elementGridH >> 1;
        if (!isBig) {
            int w = this.elementGridW * 2;
            int h = this.elementGridH * 2;
            int i = 0;
            while (i < this.starNumParam) {
                int px = x + r.nextInt(w) - (this.starW >> 1);
                int py = y + r.nextInt(h) - (this.starH >> 1);
                Star s = new Star(px, py);
                this.v_star.addElement(s);
                ++i;
            }
        } else {
            int w = this.elementGridW + this.elementBigW;
            int h = this.elementGridH + this.elementBigH;
            int i = 0;
            while (i < this.starNumParam) {
                int px = x + r.nextInt(w) - (this.starW >> 1);
                int py = y + r.nextInt(h) - (this.starH >> 1);
                Star s = new Star(px, py);
                this.v_star.addElement(s);
                ++i;
            }
        }
    }

    class Star {
        int x;
        int y;
        int step;
        int startY;

        public Star(int xx, int yy) {
            this.x = xx;
            this.y = yy;
            this.step = 0;
            this.startY = yy;
        }

        public void draw(Graphics g) {
            g.setClip(this.x, this.y, OctopusBlasts.this.starW, OctopusBlasts.this.starH);
            g.drawImage(OctopusBlasts.this.starImg, this.x, this.y - this.step * OctopusBlasts.this.starH, 0);
        }

        public boolean logic() {
            ++this.step;
            if (this.step >= 4) {
                this.step = 0;
                this.x += MainCanvas.menu.getRandom().nextInt(OctopusBlasts.this.starW >> 1);
                this.y += MainCanvas.menu.getRandom().nextInt(OctopusBlasts.this.starH);
                if (this.y - this.startY > OctopusBlasts.this.elementGridH) {
                    return true;
                }
            }
            return false;
        }
    }
}

