/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.World;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Train {
    private int _iX;
    private int _iY;
    private int _iShiftX = 0;
    private int _iOffsetX = 0;
    private int _iTmpShift = 40;
    private int _iTmpPositionX = 0;
    private int _iTmpDefaultPositionX = 0;
    private int _iType = -1;
    private int _iLength = 1;
    private int _iDir = -1;
    private int DIR_LEFT = 1;
    private int DIR_RIGHT = 0;
    private int _iDelay = 0;
    private int[] _iLightFrameSequence = new int[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1};
    private int _iLightFrame = 0;
    private final int RANDOM_RANGE;
    private final int RANDOM_RATIO;
    private final int DELAY_MAX;
    private final int DELAY_MIN;
    private boolean _bIsMoveable = false;
    private boolean _bIsActive = false;
    private boolean _bDraw = false;
    private Sprite _sprTrain;
    private Sprite _sprTrainLight1;
    private Sprite _sprTrainLight2;
    private Rectangle _rectTrain;
    private Rectangle _rectTrafficLight;
    private World _world;
    int color = 255;
    private boolean paintTrain = false;
    private boolean _bGameOver = false;

    public Train(World world) {
        this.RANDOM_RANGE = 120;
        this.RANDOM_RATIO = 40;
        this.DELAY_MAX = 10;
        this.DELAY_MIN = 5;
        this.setGameOver(false);
        this._world = world;
        this.intiSprites();
        this._iLightFrame = Math.abs(RandomNum.getRandomInt(100, 0)) > 50 ? 0 : 4;
    }

    private void intiSprites() {
        this._sprTrain = Resources.resSprs[19];
        this._sprTrainLight1 = Resources.resSprs[30];
        this._sprTrainLight2 = Resources.resSprs[31];
    }

    public void activateTrain(int _x, int _y) {
        this.setGameOver(false);
        if (this._rectTrain != null && this._rectTrain.y > this._world.getHeight()) {
            this.setActive(false);
            return;
        }
        this._iLength = this.getRandomLength();
        this._iDelay = RandomNum.getRandomInt(10, 5);
        this.setX(_x);
        this.setY(_y);
        if (this._world._tTiles[this.getX()][this.getY()].getType() != 3) {
            this.setActive(true);
            this.setMoveable(true);
            return;
        }
        if (this._iDelay < 0) {
            this._iDelay *= -1;
        }
        this._iOffsetX = this._iDir == this.DIR_LEFT ? (this._iLength + 5) * (this._sprTrain.getWidth() + (this._sprTrain.getWidth() >> 2)) * 1 : (this._iLength + 5) * (this._sprTrain.getWidth() + (this._sprTrain.getWidth() >> 2)) * 1;
        this._rectTrain = new Rectangle(0 - this._iOffsetX, this._world._tTiles[this.getX()][this.getY()].get_rectTile().y - this._sprTrain.getHeight() + (this._sprTrain.getHeight() >> 1), this._iLength * this._sprTrain.getWidth(), this._world._tTiles[this.getX()][this.getY()].get_rectTile().height);
        this._rectTrafficLight = new Rectangle(this._world._tTiles[this._world.getTOTAL_COLS() >> 1][this.getY()].get_rectTile().x, this._world._tTiles[this.getX()][this.getY()].get_rectTile().y, this._sprTrainLight2.getWidth(), this._sprTrainLight1.getHeight());
        this._sprTrain.setPosition(this._rectTrain.x, this._rectTrain.y + (this._sprTrain.getHeight() >> 1));
        this._iTmpDefaultPositionX = this._iTmpPositionX = this._rectTrain.x - (this._iOffsetX >> 2) << 2;
        this._iTmpShift = 25;
        this.setActive(true);
        this.setMoveable(true);
        if (this._rectTrain != null) {
            if (this._rectTrain.y > this._world.getHeight()) {
                this.setActive(false);
                return;
            }
            this.setActive(true);
            this.setMoveable(true);
        }
    }

    private int getRandomLength() {
        int _iTmpLenght = RandomNum.getRandomInt(120, 0);
        if (_iTmpLenght < 0) {
            _iTmpLenght *= -1;
        }
        if (_iTmpLenght < 40) {
            return 1;
        }
        if (_iTmpLenght < 80) {
            return 2;
        }
        if (_iTmpLenght < 120) {
            return 3;
        }
        return 1;
    }

    public void update(long lastRunLenght) {
        if (this._rectTrafficLight != null && this._rectTrafficLight.y > this._world.getHeight()) {
            this.setActive(false);
        }
        if (this.isActive() && this._rectTrain != null) {
            this._iLightFrame = this._iLightFrame < this._iLightFrameSequence.length - 1 ? ++this._iLightFrame : 0;
            if (this._iDelay > 0) {
                this._iDelay = (int)((long)this._iDelay - lastRunLenght);
            } else {
                this._bDraw = true;
                this._rectTrain.y = this._world._tTiles[this.getX()][this.getY()].get_rectTile().y - this._sprTrain.getHeight() + (this._sprTrain.getHeight() >> 1);
                this.move();
            }
            this._rectTrafficLight.y = this._world._tTiles[this.getX()][this.getY()].get_rectTile().y;
        }
        if (this._rectTrafficLight != null) {
            this._rectTrafficLight.y = this._world._tTiles[this.getX()][this.getY()].get_rectTile().y;
        }
        if (this._rectTrafficLight != null && this._rectTrafficLight.y > this._world.getHeight()) {
            this.setActive(false);
        }
    }

    public void paint(Graphics g) {
        if (this.isActive()) {
            this.paintTrain(g);
        }
        this.paintTrafficLights(g);
        this.checkGameOver();
    }

    private void paintTrain(Graphics g) {
        if (this._bDraw && this._rectTrain != null) {
            for (int _i = 0; _i < this._iLength; ++_i) {
                this._sprTrain.setPosition(this._rectTrain.x + _i * this._sprTrain.getWidth(), this._rectTrain.y);
                this._sprTrain.paint(g);
            }
        }
    }

    private void paintTrafficLights(Graphics g) {
        if (this._rectTrafficLight != null) {
            this._sprTrainLight1.setPosition(this._rectTrafficLight.x, this._rectTrafficLight.y - (this._world._tTiles[this.getX()][this.getY()].get_rectTile().height >> 1));
            this._sprTrainLight1.paint(g);
            this._sprTrainLight2.setPosition(this._rectTrafficLight.x - (this._sprTrainLight2.getWidth() >> 1), this._rectTrafficLight.y - (this._world._tTiles[this.getX()][this.getY()].get_rectTile().height >> 1));
            this._sprTrainLight2.setFrame(this._iLightFrameSequence[this._iLightFrame]);
            this._sprTrainLight2.paint(g);
        }
    }

    private void move() {
        if (this._iDir == this.DIR_LEFT) {
            if (this.getX() - 1 > 0) {
                if (this._rectTrain.x >= this._world._tTiles[this.getX() + 1][this.getY()].getPositionX() + (this._sprTrain.getWidth() << 1)) {
                    this.setX(this.getX() - 1);
                    this._iTmpPositionX -= this._iTmpShift;
                } else {
                    this._iTmpPositionX -= this._iTmpShift;
                }
            } else {
                this._iTmpPositionX -= this._iTmpShift;
                if (this._rectTrain.x + this._rectTrain.width < 0) {
                    // empty if block
                }
            }
        } else if (this._iDir == this.DIR_RIGHT) {
            if (this.getX() + 1 < this._world.getTOTAL_COLS()) {
                if (this._rectTrain.x >= this._world._tTiles[this.getX() + 1][this.getY()].getPositionX() + (this._sprTrain.getWidth() << 1)) {
                    this.setX(this.getX() + 1);
                    this._iTmpPositionX += this._iTmpShift;
                } else {
                    this._iTmpPositionX += this._iTmpShift;
                }
            } else {
                this._iTmpPositionX += this._iTmpShift;
                if (this._rectTrain.x > this._world.getWidth()) {
                    // empty if block
                }
            }
        }
        if (this._sprTrain.getX() > this._world.getWidth()) {
            this.reset();
        }
        this._iTmpPositionX += this._iTmpShift;
        if (this._rectTrain != null) {
            this._rectTrain.x = this._iTmpPositionX >> 2;
        } else {
            System.out.println("is NULL");
        }
    }

    private void deactivate() {
        this.setGameOver(false);
        this.setActive(false);
        this.activateTrain(0, this.getY());
    }

    private void reset() {
        this.deactivate();
    }

    private void setGameOver(boolean gameOver) {
        this._bGameOver = gameOver;
    }

    public boolean isGameOver() {
        return this._bGameOver;
    }

    public void checkGameOver() {
        if (this.isActive() && this._rectTrain != null) {
            if (this._rectTrain.x + this._rectTrain.width < 0) {
                return;
            }
            if (this._rectTrain.x > this._world.getWidth()) {
                return;
            }
            if (this._rectTrain.y > this._world.getHeight()) {
                return;
            }
            if (this._rectTrain.y + this._rectTrain.height < 0) {
                return;
            }
            if (this._rectTrain.contains(this._world.getCharacter().get_rectChar().x, this._world.getCharacter().get_rectChar().y) && this.getY() == this._world.getCharacter().get_iY()) {
                this.setGameOver(true);
                return;
            }
        }
    }

    public void setActive(boolean _bIsActive) {
        this._bIsActive = _bIsActive;
    }

    public boolean isActive() {
        return this._bIsActive;
    }

    public void setMoveable(boolean _bIsMoveable) {
        this._bIsMoveable = _bIsMoveable;
    }

    public boolean isMoveable() {
        return this._bIsMoveable;
    }

    public void setX(int _iX) {
        this._iX = _iX;
    }

    public int getX() {
        return this._iX;
    }

    public void setY(int _iY) {
        this._iY = _iY;
    }

    public int getY() {
        return this._iY;
    }
}

