/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.World;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Tree {
    private int _iX = 0;
    private int _iY = 0;
    private int _iType = 0;
    private int _iTYPE_TREE_BIG = 0;
    private int _iTYPE_TREE_SMALL = 1;
    private int RANDOM_RANGE = 100;
    private int RANDOM_RATIO = 50;
    private boolean _bIsActive = false;
    private World _world;
    private Sprite _sprTree;
    private Rectangle _rectTree;
    private PreparedText _ptNum;

    public Tree(World world) {
        this._world = world;
        this._ptNum = new PreparedText(Resources.resGFonts[0]);
    }

    public void activateTree(int x, int y) {
        this.set_iType(RandomNum.getRandomInt(this.RANDOM_RANGE - 1, 0) / this.RANDOM_RATIO);
        if (this.get_iType() < 0) {
            this.set_iType(this.get_iType() * -1);
        }
        this.setSprite(this.get_iType());
        this.setX(x);
        this.setY(y);
        if (this._world._tTiles[this.getX()][this.getY()].getType() != 0) {
            this.setActive(false);
            return;
        }
        this._rectTree = new Rectangle(this._world._tTiles[this.getX()][this.getY()].get_rectTile().x, this._world._tTiles[this.getX()][this.getY()].get_rectTile().y, this._world._tTiles[this.getX()][this.getY()].get_rectTile().width, this._world._tTiles[this.getX()][this.getY()].get_rectTile().height);
        this._world._tTiles[this.getX()][this.getY()].setEmpty(false);
        this.setActive(true);
        if (this._sprTree.getY() + (this._sprTree.getHeight() >> 3) >= this._world.getHeight()) {
            this.deactivate();
        }
        if (this._rectTree.y >= this._world.getHeight()) {
            this.deactivate();
        }
        if (this._rectTree.y + this._rectTree.height >= this._world.getHeight()) {
            this.deactivate();
        }
        if (this._sprTree.getY() >= this._world.getHeight()) {
            this.deactivate();
        }
    }

    public void update() {
        if (this.isActive() && this._rectTree != null) {
            this._rectTree.y = this._world._tTiles[this.getX()][this.getY()].get_rectTile().y - (this._sprTree.getHeight() >> 1);
        }
        if (this._world._tTiles[this.getX()][this.getY()].getType() != 0) {
            this.deactivate();
        }
        if (this._sprTree.getY() + (this._sprTree.getHeight() >> 3) >= this._world.getHeight()) {
            this.deactivate();
        }
        if (this._rectTree != null && this._rectTree.y >= this._world.getHeight()) {
            this.deactivate();
        }
        if (this._rectTree == null) {
            this.deactivate();
        }
    }

    public void paint(Graphics g) {
        if (this.isActive() && this._rectTree != null) {
            this._sprTree.setPosition(this.get_rectTree().x, this.get_rectTree().y);
            this._sprTree.paint(g);
        }
    }

    private void setSprite(int type) {
        this._sprTree = this.get_iType() == this._iTYPE_TREE_BIG ? Resources.resSprs[24] : Resources.resSprs[25];
    }

    private void deactivate() {
        this.setActive(false);
        this._world._tTiles[this.getX()][this.getY()].setEmpty(true);
    }

    public void setX(int _iX) {
        this._iX = _iX;
    }

    public int getX() {
        return this._iX;
    }

    public void setY(int _iY) {
        this._iY = _iY;
    }

    public int getY() {
        return this._iY;
    }

    public void set_iType(int _iType) {
        this._iType = _iType;
    }

    public int get_iType() {
        return this._iType;
    }

    public void setActive(boolean _bIsActive) {
        this._bIsActive = _bIsActive;
    }

    public boolean isActive() {
        return this._bIsActive;
    }

    public void set_rectTree(Rectangle _rectTree) {
        this._rectTree = _rectTree;
    }

    public Rectangle get_rectTree() {
        return this._rectTree;
    }
}

