/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.fx.SoundManager;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenLanguage;
import sk.inlogic.util.Keys;

public class MainCanvas
extends GameCanvas
implements Runnable {
    public static final int FPS = 40;
    public static boolean languageFR = false;
    public static int lastPointerPressedX = 0;
    public static int lastPointerPressedY = 0;
    public static int counterX = 0;
    public static int counterY = 0;
    public static int slcPack = 0;
    public static int slcLvl = 0;
    public static boolean music = false;
    public static int WIDTH = 0;
    public static int HEIGHT = 0;
    public static int WIDTH_FROM_DC = 0;
    public static int HEIGHT_FROM_DC = 0;
    private static Thread mainThread;
    private Vector activeScreens = new Vector();
    public long lLastRun;
    private boolean handsetTiled;
    private boolean interuptionIn;
    private boolean paintIn;
    private boolean paintPaused;
    private boolean bScreenSizeAdjusted;
    public static int[] levelPackp;
    public static int allLevel;
    public static int actualLevel;
    public static int moveCounter;
    public static boolean moveCheck;
    public static int controlsTut;
    public static int totalStars;
    public static int totalBonusStars;
    public static SoundManager soundManager;
    public static boolean touchActivated;
    public static int interuption_nokia;
    public static int nokia;
    private static int iDesignatedFps;
    private static int iDesignatedTime;
    private static long lStartTime;
    private static long lRunTime;
    private static long iDiff;
    public static int iFpsPrint;
    public static int iCnt;
    public static int iWait;
    public static long iTime;

    public MainCanvas() {
        super(false);
        this.initCanvas();
        Keys.canvas = this;
        this.handsetTiled = false;
        soundManager = new SoundManager(2);
        soundManager.LoadPlayList(Sounds.GAME_SOUND_FILES, Sounds.GAME_SOUND_TYPES, Sounds.GAME_SOUND_FLAGS);
    }

    public void startGame() {
        mainThread = new Thread(this);
        mainThread.start();
    }

    private void initCanvas() {
        super.setFullScreenMode(true);
        mainThread = new Thread(this);
        mainThread.start();
        this.interuptionIn = false;
        this.paintIn = false;
        this.paintPaused = false;
        this.bScreenSizeAdjusted = false;
        this.lLastRun = 0L;
    }

    public void changeLastActiveScreen(IScreen newScreen) {
        if (newScreen == null || this.activeScreens.size() == 0) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        this.paintPaused = true;
        while (this.paintIn) {
            System.out.println("wait");
        }
        ((IScreen)this.activeScreens.lastElement()).afterHide();
        this.activeScreens.removeElement(this.activeScreens.lastElement());
        System.gc();
        newScreen.beforeShow();
        this.activeScreens.addElement(newScreen);
        this.paintPaused = false;
    }

    public void addActiveScreen(IScreen screen) {
        if (screen == null) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        screen.beforeShow();
        this.activeScreens.addElement(screen);
    }

    public void removeLastActiveScreen() {
        if (this.activeScreens.size() == 0) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        this.paintPaused = true;
        while (this.paintIn) {
            System.out.println("wait");
        }
        ((IScreen)this.activeScreens.lastElement()).afterHide();
        this.activeScreens.removeElement(this.activeScreens.lastElement());
        System.gc();
        this.paintPaused = false;
    }

    public void hideNotify() {
        if (this.interuptionIn) {
            return;
        }
        this.interuptionIn = true;
        soundManager.Stop();
        ((IScreen)this.activeScreens.lastElement()).beforeInteruption();
    }

    public void showNotify() {
        if (!this.interuptionIn) {
            return;
        }
        this.interuptionIn = false;
        ((IScreen)this.activeScreens.lastElement()).afterInteruption();
        this.repaint();
    }

    public boolean isInterrupted() {
        return this.interuptionIn;
    }

    void updateSoundTimer() {
    }

    static final long NOW() {
        return System.currentTimeMillis();
    }

    public void run() {
        while (mainThread == Thread.currentThread()) {
            lRunTime = MainCanvas.NOW() - lStartTime;
            lStartTime = MainCanvas.NOW();
            iDiff = (long)iDesignatedTime - lRunTime;
            if ((iTime += iDiff) < 0L) {
                iTime = 0L;
            }
            try {
                Thread.sleep(iTime);
            }
            catch (Throwable t) {
                // empty catch block
            }
            int activeScreensCount = this.activeScreens.size();
            for (int i = 0; i < activeScreensCount; ++i) {
                ((IScreen)this.activeScreens.elementAt(i)).update(lRunTime);
            }
            Thread.yield();
        }
    }

    public void run2() {
        this.lLastRun = System.currentTimeMillis();
        while (Thread.currentThread() == mainThread) {
            Thread.yield();
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lLastRun < 40L) continue;
            if (!this.bScreenSizeAdjusted) {
                this.repaint();
                continue;
            }
            if (this.isHandsetTiled()) {
                this.repaint();
                continue;
            }
            int activeScreensCount = this.activeScreens.size();
            for (int i = 0; i < activeScreensCount; ++i) {
                ((IScreen)this.activeScreens.elementAt(i)).update(currentTime - this.lLastRun);
            }
            this.lLastRun = currentTime;
        }
    }

    public void paint(Graphics g) {
        if (this.paintPaused) {
            return;
        }
        HEIGHT = g.getClipHeight();
        WIDTH = g.getClipWidth();
        if (WIDTH_FROM_DC < HEIGHT_FROM_DC && WIDTH > HEIGHT || WIDTH_FROM_DC > HEIGHT_FROM_DC && WIDTH < HEIGHT) {
            this.handsetTiled = true;
            this.paintResRotation(g);
            int h = HEIGHT;
            HEIGHT = WIDTH;
            WIDTH = h;
            return;
        }
        this.handsetTiled = false;
        if (!this.bScreenSizeAdjusted) {
            HEIGHT = g.getClipHeight();
            WIDTH = g.getClipWidth();
            this.bScreenSizeAdjusted = true;
            this.addActiveScreen(new ScreenLanguage(this));
        }
        if (this.activeScreens.size() > 0) {
            this.paintIn = true;
            g.setColor(0);
            g.fillRect(0, 0, WIDTH, HEIGHT);
            g.setColor(0xFFFFFF);
            int activeScreensCount = this.activeScreens.size();
            for (int i = 0; i < activeScreensCount; ++i) {
                ((IScreen)this.activeScreens.elementAt(i)).paint(g);
            }
            this.paintIn = false;
        }
    }

    private void paintResRotation(Graphics g) {
        g.setClip(0, 0, WIDTH, HEIGHT);
        g.setColor(0);
        g.fillRect(0, 0, WIDTH, HEIGHT);
        if (Resources.resImgs[16] == null) {
            Resources.loadImage(16);
        } else {
            g.drawImage(Resources.resImgs[16], WIDTH / 2, HEIGHT / 2, 3);
        }
    }

    private int modifyKeyCode(int keyCode) {
        return keyCode;
    }

    public void keyPressed(int keyCode) {
        if (this.handsetTiled) {
            return;
        }
        if ((keyCode = this.modifyKeyCode(keyCode)) != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            Keys.keyPressed(keyCode);
            if (this.activeScreens.size() > 0) {
                ((IScreen)this.activeScreens.lastElement()).keyPressed(keyCode);
            }
        }
        if (Keys.isKeyPressed(-6) || Keys.isKeyPressed(-7)) {
            this.onKeyReleased(keyCode);
        }
    }

    private void onKeyReleased(int keyCode) {
        if (this.activeScreens.size() > 0) {
            ((IScreen)this.activeScreens.lastElement()).keyReleased(keyCode);
        }
        Keys.keyReleased(keyCode);
    }

    public void keyReleased(int keyCode) {
        if (Keys.isKeyPressed(-6) || Keys.isKeyPressed(-7)) {
            return;
        }
        if (this.handsetTiled) {
            return;
        }
        if ((keyCode = this.modifyKeyCode(keyCode)) != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55 && !Keys.isKeyPressed(-6) && !Keys.isKeyPressed(-7) && keyCode != -6 && keyCode != -7) {
            this.onKeyReleased(keyCode);
        }
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void setHandsetTiled(boolean handsetTiled) {
        this.handsetTiled = handsetTiled;
    }

    public boolean isHandsetTiled() {
        return this.handsetTiled;
    }

    static {
        levelPackp = new int[]{0, 1, 2};
        allLevel = 59;
        actualLevel = 0;
        moveCheck = false;
        controlsTut = 0;
        totalStars = 0;
        totalBonusStars = 0;
        touchActivated = false;
        String fullCanvasSize = "220x176";
        try {
            WIDTH = WIDTH_FROM_DC = Integer.valueOf(fullCanvasSize.substring(0, fullCanvasSize.indexOf("x"))).intValue();
            HEIGHT = HEIGHT_FROM_DC = Integer.valueOf(fullCanvasSize.substring(fullCanvasSize.indexOf("x") + 1)).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        interuption_nokia = 0;
        nokia = 0;
        iDesignatedFps = 50;
        iDesignatedTime = 1000 / iDesignatedFps;
        lStartTime = 0L;
        lRunTime = 0L;
        iFpsPrint = 0;
        iCnt = 0;
    }
}

