/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private MainCanvas mainCanvas;
    public static final int COMP_ID_PLAY = 0;
    public static final int COMP_ID_INSTRUCTIONS = 1;
    public static final int COMP_ID_SCORE = 2;
    public static final int COMP_ID_ABOUT = 3;
    private static final int COMP_ID_SETTINGS = 4;
    private static final int COMP_ID_QUIT = 5;
    public static final int COMP_ID_OPTIONS = 6;
    public static final int COMP_ID_CHARACTER_BIRD = 7;
    public static final int COMP_ID_CHARACTER_FROG = 8;
    public static final int COMP_ID_CHARACTER_MOLE = 9;
    public static final int COMP_ID_CHARACTER_PIG = 10;
    public static final int COMP_ID_CHARACTER_PLATYPUS = 11;
    public static final int COMP_ID_CHARACTER_TURTLE = 12;
    private static final int _BUTTON_NO = 13;
    private static final int _BUTTON_YES = 14;
    private static final int _BUTTON_BACK = 15;
    public static final int COMP_ID_NONE = 16;
    private static final int TOTAL_COMP_IDS = 17;
    public static final int COMP_ID_PLAY_TXT = 0;
    public static final int COMP_ID_INSTRUCTIONS_TXT = 1;
    public static final int COMP_ID_SCORE_TXT = 2;
    public static final int COMP_ID_ABOUT_TXT = 3;
    public static final int COMP_ID_NONE_TXT = 6;
    private static final int TOTAL_COMP_IDS_TXT = 7;
    private int actualSceen = 0;
    private static final int SCREEN_MAIN_MENU = 0;
    private static final int SCREEN_INSTRUCTIONS = 1;
    private static final int SCREEN_ABOUT = 2;
    private static final int SCREEN_START_GAME = 3;
    private static final int SCREEN_QUIT_GAME = 4;
    private static final int SCREEN_OPTION_GAME = 5;
    private static final int SCREEN_TOTAL = 6;
    private int _TOTAL_BUTTONS = 3;
    private Rectangle[] rectItems = new Rectangle[17];
    private Rectangle[] rectNavigationButtons = new Rectangle[this._TOTAL_BUTTONS];
    private Rectangle[] rectItems_TXT = new Rectangle[7];
    private int[][] _animationSequence = new int[6][13];
    private AnimationComponent[] _animationComponents = new AnimationComponent[22];
    private int[] _iUnlockedCharacters = new int[]{1, 0, 0, 0, 0, 0};
    private int[] _iCharactersCost = new int[]{0, 25, 50, 75, 100, 150};
    private Rectangle rectLeftFk;
    private Rectangle rectRightFk;
    private Rectangle rectBB_BACK;
    private Rectangle rectBB_MENU;
    private Rectangle rectTopBig;
    private Rectangle rectTopLittle;
    private Rectangle rectTopLittleTXT;
    private Rectangle rectTopScore;
    private Rectangle rectTopCoins;
    private Rectangle rectTitle;
    private Rectangle rectPanel;
    private Rectangle rectWindow;
    private Rectangle rectText;
    private Rectangle rectMenuTopDecor;
    private int selectedCharacterId;
    private int selectedCompId;
    private int selectorCompId;
    private int interuption = 0;
    private int _iTotalColRectTile = 0;
    private int _iTotalRowRectTile = 0;
    private int _iTotalColWindowsTile = 0;
    private int _iTotalRowWindowsTile = 0;
    private int _iTotalColButtonTile = 0;
    private int _iTotalRowButtonTile = 0;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private boolean needRepaint = false;
    private boolean activeButton = true;
    private PreparedText menuItem;
    private PreparedText title;
    private PreparedText _ptTopScore;
    private PreparedText _ptTopCoins;
    private PreparedText _ptCost;
    private PreparedText instruction;
    private PreparedText versionOfGame;
    private int _iTextOffsetY;
    private Image _imgGameLogo;
    private Image _imgCorpLogo;
    private Image _imgIconPlay;
    private Image _imgIconOptions;
    private Image _imgIconQuit;
    private Image _imgIconBack;
    private Image _imgIconYes;
    private Image _imgIconNo;
    private Image _imgCharacterBird;
    private Image _imgCharacterFrog;
    private Image _imgCharacterMole;
    private Image _imgCharacterPlatypus;
    private Image _imgCharacterPig;
    private Image _imgCharacterTurtle;
    private Sprite _sprArrows;
    private Sprite _sprButton;
    private Sprite _sprCheckBox;
    private Sprite _sprCoin;
    private Sprite _sprSelector;
    private Sprite _sprWindow;
    private Sprite _sprWorldTile;
    private static int _WIDTH = 0;
    private static int _HEIGHT = 0;
    private static int _totalRowTiles = 0;
    private static int _totalColTiles = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iSequence = 0;
    boolean _bChangeSequence = false;
    private int _iNextScreen;
    boolean check = false;
    int _finalHeight;
    int _finalRectHeight;
    int _off;
    int _iCicle = 10;
    private int musicControler = 0;
    private int _iBestScoreSave = 0;
    private int _iScoresCount = 0;
    private int _iCoins = 0;
    private int _iCoinsCount = 0;
    private int _iChar = 0;
    private int _iCharCount = 0;
    int a;
    private boolean releasedTouch = false;
    private int sel = this.selectedCompId;
    private int s = this.selectedCompId;
    private int force = this.selectedCompId;
    int posX = 0;
    int posY = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreenMenu(MainCanvas mainCanvas, int selectedItem) {
        this.mainCanvas = mainCanvas;
        this.initDimensions();
        this.selectedCompId = 0;
        this.selectorCompId = 0;
        this.selectedCompId = 0;
        this.selectorCompId = 0;
        this.selectedCharacterId = 7;
        System.out.println("Start screen: " + MainCanvas.soundManager.IsSoundOn());
        try {
            if (MainCanvas.soundManager.IsSoundOn()) {
                MainCanvas.soundManager.SetSoundOn(true);
                MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (MainCanvas.soundManager.IsSoundOn()) {
                MainCanvas.soundManager.SetSoundOn(true);
                MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
            }
        }
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initTxt();
        this.calculatePositions();
        this.loadData();
        if (this._iCoins == 0) {
            this.save();
        }
        this.prepareTxt();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.startAnimation(true, 0);
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{1, 0, 8, 7, 9, 2, 4, 3, 10, 11, 14, 13, 12, 15});
        Resources.loadSprites(new int[]{43, 40, 41, 42, 33, 39, 12});
        Resources.loadGFonts(new int[]{1, 0});
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{1, 0, 8, 7, 9, 2, 4, 3, 10, 11, 14, 13, 12, 15});
        Resources.freeSprites(new int[]{43, 40, 41, 42, 33, 39, 12});
        Resources.freeGFonts(new int[]{1, 0});
        Resources.freeText(0);
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgGameLogo = Resources.resImgs[1];
        this._imgCorpLogo = Resources.resImgs[0];
        this._imgIconBack = Resources.resImgs[2];
        this._imgIconNo = Resources.resImgs[4];
        this._imgIconOptions = Resources.resImgs[7];
        this._imgIconPlay = Resources.resImgs[8];
        this._imgIconQuit = Resources.resImgs[9];
        this._imgIconYes = Resources.resImgs[3];
        this._imgCharacterBird = Resources.resImgs[10];
        this._imgCharacterFrog = Resources.resImgs[11];
        this._imgCharacterMole = Resources.resImgs[14];
        this._imgCharacterPlatypus = Resources.resImgs[12];
        this._imgCharacterPig = Resources.resImgs[13];
        this._imgCharacterTurtle = Resources.resImgs[15];
    }

    private void initSprites() {
        this._sprArrows = Resources.resSprs[43];
        this._sprButton = Resources.resSprs[40];
        this._sprCheckBox = Resources.resSprs[42];
        this._sprCoin = Resources.resSprs[33];
        this._sprSelector = Resources.resSprs[39];
        this._sprWindow = Resources.resSprs[41];
        this._sprWorldTile = Resources.resSprs[12];
    }

    public void initTxt() {
        this.menuItem = new PreparedText(Resources.resGFonts[0]);
        this.versionOfGame = new PreparedText(Resources.resGFonts[0]);
        this.instruction = new PreparedText(Resources.resGFonts[1]);
        this._ptTopScore = new PreparedText(Resources.resGFonts[0]);
        this._ptTopCoins = new PreparedText(Resources.resGFonts[0]);
        this._ptCost = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 0;
        this._animationSequence[0][1] = 1;
        this._animationSequence[0][2] = 2;
        this._animationSequence[0][3] = 3;
        this._animationSequence[0][4] = 4;
        this._animationSequence[0][5] = 5;
        this._animationSequence[0][6] = 6;
        this._animationSequence[0][7] = 7;
        this._animationSequence[0][8] = 8;
        this._animationSequence[0][9] = 9;
        this._animationSequence[0][10] = 10;
        this._animationSequence[0][11] = 20;
        this._animationSequence[0][12] = 21;
        this._animationSequence[1][0] = 12;
        this._animationSequence[1][1] = 13;
        this._animationSequence[1][2] = 17;
        this._animationSequence[1][3] = 11;
        this._animationSequence[1][4] = 18;
        this._animationSequence[1][5] = -1;
        this._animationSequence[1][6] = -1;
        this._animationSequence[1][7] = -1;
        this._animationSequence[1][8] = -1;
        this._animationSequence[1][9] = -1;
        this._animationSequence[1][10] = -1;
        this._animationSequence[1][11] = -1;
        this._animationSequence[1][12] = -1;
        this._animationSequence[2][0] = 12;
        this._animationSequence[2][1] = 17;
        this._animationSequence[2][2] = 18;
        this._animationSequence[2][3] = -1;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[2][6] = -1;
        this._animationSequence[2][7] = -1;
        this._animationSequence[2][8] = -1;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[2][11] = -1;
        this._animationSequence[2][12] = -1;
        this._animationSequence[4][0] = 12;
        this._animationSequence[4][1] = 18;
        this._animationSequence[4][2] = 19;
        this._animationSequence[4][3] = 11;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
        this._animationSequence[4][9] = -1;
        this._animationSequence[4][10] = -1;
        this._animationSequence[4][11] = -1;
        this._animationSequence[4][12] = -1;
        this._animationSequence[5][0] = 11;
        this._animationSequence[5][1] = 14;
        this._animationSequence[5][2] = 15;
        this._animationSequence[5][3] = 16;
        this._animationSequence[5][4] = 17;
        this._animationSequence[5][5] = 18;
        this._animationSequence[5][6] = -1;
        this._animationSequence[5][7] = -1;
        this._animationSequence[5][8] = -1;
        this._animationSequence[5][9] = -1;
        this._animationSequence[5][10] = -1;
        this._animationSequence[5][11] = -1;
        this._animationSequence[5][12] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this.rectItems[0], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[0].startShowAnimation(3);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems[6], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[1].startShowAnimation(0);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[5], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems[7], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[3].startShowAnimation(0);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectItems[8], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[4].startShowAnimation(1);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectItems[9], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[5].startShowAnimation(0);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this.rectItems[10], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectItems[11], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[7].startShowAnimation(0);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectItems[12], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[8].startShowAnimation(1);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this.rectTopBig, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[9].startShowAnimation(2);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this.rectMenuTopDecor, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this.rectWindow, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[11].startShowAnimation(2);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[12].startShowAnimation(2);
        this._animationComponents[13] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[13].startShowAnimation(2);
        this._animationComponents[14] = new AnimationComponent(this.mainCanvas, this.rectItems[1], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[14].startShowAnimation(2);
        this._animationComponents[15] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[15].startShowAnimation(2);
        this._animationComponents[16] = new AnimationComponent(this.mainCanvas, this.rectItems[2], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[16].startShowAnimation(2);
        this._animationComponents[17] = new AnimationComponent(this.mainCanvas, this.rectItems[15], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[17].startShowAnimation(1);
        this._animationComponents[18] = new AnimationComponent(this.mainCanvas, this.rectItems[14], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[18].startShowAnimation(1);
        this._animationComponents[19] = new AnimationComponent(this.mainCanvas, this.rectItems[13], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[19].startShowAnimation(0);
        this._animationComponents[20] = new AnimationComponent(this.mainCanvas, this.rectTopCoins, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[20].startShowAnimation(0);
        this._animationComponents[21] = new AnimationComponent(this.mainCanvas, this.rectTopScore, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[21].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(3);
        this._animationComponents[1].startShowAnimation(0);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(0);
        this._animationComponents[4].startShowAnimation(1);
        this._animationComponents[5].startShowAnimation(0);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(0);
        this._animationComponents[8].startShowAnimation(1);
        this._animationComponents[9].startShowAnimation(2);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11].startShowAnimation(2);
        this._animationComponents[12].startShowAnimation(2);
        this._animationComponents[13].startShowAnimation(2);
        this._animationComponents[14].startShowAnimation(2);
        this._animationComponents[15].startShowAnimation(2);
        this._animationComponents[16].startShowAnimation(2);
        this._animationComponents[17].startShowAnimation(1);
        this._animationComponents[18].startShowAnimation(1);
        this._animationComponents[19].startShowAnimation(0);
        this._animationComponents[20].startShowAnimation(0);
        this._animationComponents[21].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(3);
        this._animationComponents[1].startHideAnimation(0);
        this._animationComponents[2].startHideAnimation(1);
        this._animationComponents[3].startHideAnimation(0);
        this._animationComponents[4].startHideAnimation(1);
        this._animationComponents[5].startHideAnimation(0);
        this._animationComponents[6].startHideAnimation(1);
        this._animationComponents[7].startHideAnimation(0);
        this._animationComponents[8].startHideAnimation(1);
        this._animationComponents[9].startHideAnimation(2);
        this._animationComponents[10].startHideAnimation(2);
        this._animationComponents[11].startHideAnimation(2);
        this._animationComponents[12].startHideAnimation(2);
        this._animationComponents[13].startHideAnimation(2);
        this._animationComponents[14].startHideAnimation(2);
        this._animationComponents[15].startHideAnimation(2);
        this._animationComponents[16].startHideAnimation(2);
        this._animationComponents[17].startHideAnimation(1);
        this._animationComponents[18].startHideAnimation(1);
        this._animationComponents[19].startHideAnimation(0);
        this._animationComponents[20].startHideAnimation(0);
        this._animationComponents[21].startHideAnimation(1);
    }

    private void freeGraphics() {
        this._imgGameLogo = null;
        this._imgCorpLogo = null;
        this._imgIconBack = null;
        this._imgIconNo = null;
        this._imgIconOptions = null;
        this._imgIconPlay = null;
        this._imgIconQuit = null;
        this._imgIconYes = null;
        this._imgCharacterBird = null;
        this._imgCharacterFrog = null;
        this._imgCharacterMole = null;
        this._imgCharacterPlatypus = null;
        this._imgCharacterPig = null;
        this._imgCharacterTurtle = null;
        this._sprArrows = null;
        this._sprButton = null;
        this._sprCheckBox = null;
        this._sprCoin = null;
        this._sprSelector = null;
        this._sprWindow = null;
        this._sprWorldTile = null;
    }

    public void prepareTxt() {
        String controls = "";
        this._iTextOffsetY = 0;
        controls = Resources.resTexts[0].getHashedString(16);
        this.versionOfGame.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectText.width);
        this.instruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls + "\n\n", this.rectText.width);
        this.instruction.setLineHeightCorrection(-2);
    }

    public void beforeInteruption() {
        this.check = MainCanvas.soundManager.IsSoundOn();
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        this.rectItems[0] = new Rectangle((_WIDTH >> 1) - (this._sprButton.getWidth() << 1) - (this._sprButton.getWidth() >> 1), _HEIGHT - this._sprButton.getHeight() * 7, this._sprButton.getWidth() * 5, this._sprButton.getHeight() * 5);
        this.rectItems[6] = new Rectangle(this.rectItems[0].x - (this._sprButton.getWidth() << 1) - this._sprButton.getWidth() * 4, _HEIGHT - this._sprButton.getHeight() * 6, this._sprButton.getWidth() * 4, this._sprButton.getHeight() * 4);
        this.rectItems[5] = new Rectangle(this.rectItems[0].x + this.rectItems[0].width + (this._sprButton.getWidth() << 1), _HEIGHT - this._sprButton.getHeight() * 6, this._sprButton.getWidth() * 4, this._sprButton.getHeight() * 4);
        int _windowWidth = _WIDTH >> 1;
        int _offsetX = _windowWidth % this._sprWindow.getWidth() > 0 ? _windowWidth % this._sprWindow.getWidth() : this._sprWindow.getWidth();
        int _offsetTopY = this._sprWindow.getHeight() + this._sprWindow.getWidth();
        int _offsetBottomY = this._sprWindow.getWidth();
        int _panelHeight = _HEIGHT - _offsetTopY - _offsetBottomY;
        this._finalHeight = _panelHeight % this._sprWindow.getWidth() == 0 ? _panelHeight : _panelHeight - _panelHeight % this._sprWindow.getWidth();
        this._off = _offsetX;
        this._finalRectHeight = this._finalHeight;
        this.rectPanel = new Rectangle(_offsetX, _offsetTopY, _WIDTH - (_offsetX << 1), this._finalHeight);
        this.rectText = new Rectangle(_offsetX + this._sprWindow.getWidth() + (this._sprWindow.getWidth() >> 1), _offsetTopY + this._sprArrows.getHeight(), _WIDTH - (_offsetX << 1) - (this._sprWindow.getWidth() << 1) - (this._sprWindow.getWidth() >> 1), this._finalHeight - (this._sprArrows.getHeight() << 1));
        this._finalHeight -= 2 * (this._sprWindow.getWidth() << 2);
        this._finalHeight = this._sprButton.getHeight() * 9 + (this._sprButton.getHeight() << 2 << 1) - this._sprWindow.getHeight();
        if (this._finalHeight % this._sprWindow.getHeight() > 0 && this._finalHeight % this._sprWindow.getHeight() < this._sprWindow.getHeight()) {
            this._finalHeight -= this._finalHeight % this._sprWindow.getHeight();
        }
        _offsetTopY = (_HEIGHT >> 1) - (this._finalHeight >> 1);
        this.rectWindow = new Rectangle(_offsetX, _offsetTopY, _WIDTH - (_offsetX << 1), this._finalHeight);
        int _iButtonWidth = this.rectWindow.width - (this._sprButton.getWidth() << 1);
        int _iButtonOffsetX = _iButtonWidth % this._sprButton.getWidth() > 0 ? _iButtonWidth % this._sprButton.getWidth() : this.rectWindow.x + this._sprButton.getWidth();
        int _iButtonOffsetY = this.rectWindow.y + this._sprWindow.getHeight() + this._sprButton.getHeight();
        _iButtonOffsetY = (_HEIGHT >> 1) - this._sprButton.getHeight() * 5;
        this.rectItems[1] = new Rectangle(_iButtonOffsetX, _iButtonOffsetY, _WIDTH - (_iButtonOffsetX << 1), this._sprButton.getHeight() * 3);
        this.rectItems[3] = new Rectangle(_iButtonOffsetX, _iButtonOffsetY += this._sprButton.getHeight() << 2, _WIDTH - (_iButtonOffsetX << 1), this._sprButton.getHeight() * 3);
        this.rectItems[2] = new Rectangle(_iButtonOffsetX, _iButtonOffsetY += this._sprButton.getHeight() << 2, _WIDTH - (_iButtonOffsetX << 1), this._sprButton.getHeight() * 3);
        this.rectMenuTopDecor = new Rectangle(0, 0, _WIDTH, this._sprWorldTile.getHeight() * 4);
        this.rectTopBig = new Rectangle(_WIDTH >> 1, this._imgGameLogo.getWidth() >> 4, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        int _iCharPositionX = 0;
        int _iCharPositionY = 0;
        int _iCharPositionOffsetY = _HEIGHT - this.rectItems[0].x - this.rectMenuTopDecor.height;
        _iCharPositionOffsetY /= 4;
        _iCharPositionX = this._sprCheckBox.getWidth();
        _iCharPositionY = this.rectMenuTopDecor.height;
        this.rectItems[7] = new Rectangle(0 - _iCharPositionX, _iCharPositionY, _WIDTH >> 1, this._imgCharacterBird.getHeight());
        this.rectItems[8] = new Rectangle((_WIDTH >> 1) - _iCharPositionX, _iCharPositionY, _WIDTH >> 1, this._imgCharacterBird.getHeight());
        _iCharPositionY = this.rectItems[8].y + this.rectItems[8].height + (this._imgCharacterBird.getHeight() >> 1);
        this.rectItems[9] = new Rectangle(0 - _iCharPositionX, _iCharPositionY, _WIDTH >> 1, this._imgCharacterBird.getHeight());
        this.rectItems[10] = new Rectangle((_WIDTH >> 1) - _iCharPositionX, _iCharPositionY, _WIDTH >> 1, this._imgCharacterBird.getHeight());
        _iCharPositionY = this.rectItems[10].y + this.rectItems[10].height + (this._imgCharacterBird.getHeight() >> 1);
        this.rectItems[11] = new Rectangle(0 - _iCharPositionX, _iCharPositionY, _WIDTH >> 1, this._imgCharacterBird.getHeight());
        this.rectItems[12] = new Rectangle((_WIDTH >> 1) - _iCharPositionX, _iCharPositionY, _WIDTH >> 1, this._imgCharacterBird.getHeight());
        this.rectItems[13] = new Rectangle(0, _HEIGHT - (this._sprCheckBox.getHeight() << 1), this._sprCheckBox.getWidth() << 1, this._sprCheckBox.getHeight() << 1);
        this.rectItems[14] = new Rectangle(_WIDTH - (this._sprCheckBox.getWidth() << 1), _HEIGHT - (this._sprCheckBox.getHeight() << 1), this._sprCheckBox.getWidth() << 1, this._sprCheckBox.getHeight() << 1);
        this.rectItems[15] = new Rectangle(_WIDTH - (this._sprCheckBox.getWidth() << 1), _HEIGHT - (this._sprCheckBox.getHeight() << 1), this._sprCheckBox.getWidth() << 1, this._sprCheckBox.getHeight() << 1);
        this.rectTopScore = new Rectangle(_WIDTH >> 1, this.rectMenuTopDecor.y + this.rectMenuTopDecor.height - this._sprWorldTile.getHeight(), _WIDTH >> 1, this._sprWorldTile.getHeight());
        this.rectTopCoins = new Rectangle(0, this.rectMenuTopDecor.y + this.rectMenuTopDecor.height - this._sprWorldTile.getHeight(), _WIDTH >> 1, this._sprWorldTile.getHeight());
        this.calculateWindowTiles();
    }

    private void calculateWindowTiles() {
        this._iTotalColWindowsTile = (_WIDTH - (this._off << 1)) / this._sprWindow.getWidth();
        this._iTotalRowWindowsTile = this.rectWindow.height / this._sprWindow.getWidth();
        this._iTotalColButtonTile = this.rectItems[1].width / this._sprButton.getWidth();
        this._iTotalRowButtonTile = 3;
        this._iTotalColRectTile = (_WIDTH - (this._off << 1)) / this._sprWindow.getWidth();
        this._iTotalRowRectTile = this.rectPanel.height / this._sprWindow.getWidth();
    }

    public void update(long lastRunLenght) {
        this.musicInteruptUpdate();
        this.animationController();
        this.animationComponentsUpdate();
        if (this.actualSceen == 1) {
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.actualSceen].length; ++i) {
            if (this._animationSequence[this.actualSceen][i] == -1 || this._animationComponents[this._animationSequence[this.actualSceen][i]] == null || this._animationComponents[this._animationSequence[this.actualSceen][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.actualSceen][i]].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                if (this._iNextScreen == 3) {
                    this.startGameScreen();
                }
                this._iSequence = this._iSequenceShow;
                this.actualSceen = this._iNextScreen;
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this._bChangeSequence = changeSequencem;
        this._iNextScreen = nextScreen;
        this._iSequence = this._iSequenceHide;
    }

    private void startGameScreen() {
        ScreenGame sg = new ScreenGame(this.mainCanvas, this.selectedCharacterId);
        this.mainCanvas.changeLastActiveScreen(sg);
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
        }
    }

    private void musicInteruptUpdate() {
    }

    private void loadData() {
        this.loadBestScore();
        this.loadCoinsCount();
        this.loadUnlockedCharacters();
    }

    private void loadBestScore() {
        Vector scores;
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].load()) {
            RMSObjects.rmsConnects[1].create();
        }
        if ((scores = RMSObjects.bestScores.getScoresForGame(0)) != null) {
            this._iScoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this._iScoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this._iBestScoreSave = scoreItem.scoreValue;
        }
    }

    private void loadCoinsCount() {
        Vector scores;
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        if ((scores = RMSObjects.coinsCount.getScoresForGame(0)) != null) {
            this._iCoinsCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this._iCoinsCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this._iCoins = scoreItem.scoreValue;
        }
    }

    private void loadUnlockedCharacters() {
        RMSObjects.createRMSConnect(3);
        if (!RMSObjects.rmsConnects[3].load()) {
            RMSObjects.rmsConnects[3].create();
            this.save();
            return;
        }
        Vector scores = RMSObjects.unlockedChar.getScoresForGame(0);
        if (scores != null) {
            this._iCharCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        System.out.println("scores: " + scores.size());
        for (int i = 0; i < this._iUnlockedCharacters.length; ++i) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(i);
            this._iChar = scoreItem.scoreValue;
            System.out.println("load : i : " + i + " , _iUnlockedCharacters[" + i + "]: " + this._iUnlockedCharacters[i] + " , values: " + scoreItem.scoreValue);
            this._iUnlockedCharacters[i] = this._iChar;
            System.out.println("load : i : " + i + " , _iUnlockedCharacters[" + i + "]: " + this._iUnlockedCharacters[i] + " , values: " + scoreItem.scoreValue);
        }
    }

    private void save() {
        this.saveCoins();
        for (int i = 0; i < this._iUnlockedCharacters.length; ++i) {
            this.saveUnlockedCharacters(this._iUnlockedCharacters[i], i);
        }
    }

    private void saveUnlockedCharacters(int _iActualCharacter, int _iDx) {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = _iDx;
        scoreItem.userName = Integer.toString(_iDx);
        scoreItem.scoreValue = this._iUnlockedCharacters[_iDx];
        RMSObjects.unlockedChar.userName = Integer.toString(_iDx);
        RMSObjects.unlockedChar.insertCoins(scoreItem, _iDx);
        System.out.println("save : " + scoreItem.scoreValue + " , id: " + _iDx);
        RMSObjects.createRMSConnect(3);
        if (!RMSObjects.rmsConnects[3].isExist()) {
            RMSObjects.rmsConnects[3].create();
        }
        RMSObjects.rmsConnects[3].save();
    }

    private void saveCoins() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        scoreItem.scoreValue = this._iCoins;
        RMSObjects.coinsCount.userName = Integer.toString(0);
        RMSObjects.coinsCount.insertCoins(scoreItem, 0);
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].isExist()) {
            RMSObjects.rmsConnects[0].create();
        }
        RMSObjects.rmsConnects[0].save();
    }

    private void buyOrSelectCharacter(int _iSlcd) {
        int _iTmp = _iSlcd - 7;
        if (this._iUnlockedCharacters[_iTmp] == 1) {
            this.selectedCharacterId = _iSlcd;
        } else if (this._iCoins >= this._iCharactersCost[_iTmp]) {
            this._iUnlockedCharacters[_iTmp] = 1;
            this._iCoins -= this._iCharactersCost[_iTmp];
            this.save();
            this.loadData();
        }
    }

    public void paint(Graphics g) {
        this.paintBackgroundColor(g);
        g.fillRect(0, this.rectTopBig.height, _WIDTH, 0);
        switch (this.actualSceen) {
            case 0: {
                this.paintMenuTopDecor(g);
                this.paintGameLogo(g);
                this.paintMenuCharacter(g);
                this.paintMenuCharacterCheckBoxes(g);
                this.paintMainMenuControlButtons(g);
                this.paintMainMenuSelector(g);
                this.paintMenuScore(g);
                this.paintMenuCoins(g);
                break;
            }
            case 5: {
                this.paintOptionsWindow(g);
                break;
            }
            case 1: {
                this.paintTiledWindow(g);
                this.paintInstrusctionTxt(g);
                this.paintArrows(g);
                break;
            }
            case 2: {
                this.paintTiledWindow(g);
                this.paintAboutLogo(g);
                break;
            }
            case 4: {
                this.paintTiledWindow(g);
                this.paintQuit(g);
            }
        }
        this.paintFK(g);
    }

    private void paintBackgroundColor(Graphics g) {
        g.setColor(11856989);
        g.fillRect(0, 0, _WIDTH, _HEIGHT);
    }

    private void paintMenuTopDecor(Graphics g) {
        int _iPositionY = this.rectMenuTopDecor.y;
        int _iPositionX = this.rectMenuTopDecor.x + this._sprWorldTile.getWidth() >> 1;
        for (int _x = 0; _x < this.rectMenuTopDecor.x + this.rectMenuTopDecor.width; _x += this._sprWorldTile.getWidth()) {
            for (int _y = 0; _y < this.rectMenuTopDecor.y + this.rectMenuTopDecor.height; _y += this._sprWorldTile.getHeight()) {
                if (_y == this._sprWorldTile.getWidth() * 2) {
                    this._sprWorldTile.setFrame(7);
                } else if (_y == this._sprWorldTile.getWidth() * 3) {
                    this._sprWorldTile.setFrame(3);
                    _iPositionY = _y;
                } else {
                    this._sprWorldTile.setFrame(6);
                }
                this._sprWorldTile.setPosition(_x, _y);
                this._sprWorldTile.paint(g);
            }
        }
        _iPositionY = _iPositionY + (this._sprWorldTile.getHeight() >> 1) - (this._sprCoin.getHeight() >> 1);
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this.rectTopBig.x, this.rectTopBig.y, 17);
    }

    public void paintMainMenuControlButtons(Graphics g) {
        _totalColTiles = 5;
        _totalRowTiles = 5;
        this.paintControlsButton(g, 0, _totalColTiles, _totalRowTiles, this._imgIconPlay);
        this.paintControlsButton(g, 6, --_totalColTiles, --_totalRowTiles, this._imgIconOptions);
        this.paintControlsButton(g, 5, _totalColTiles, _totalRowTiles, this._imgIconQuit);
    }

    private void paintControlsButton(Graphics g, int _idx, int _cols, int _rows, Image _imgIcon) {
        int _iTileX = 0;
        int _iTileY = 0;
        for (int _x = this.rectItems[_idx].x; _x < this.rectItems[_idx].x + this.rectItems[_idx].width; _x += this._sprButton.getWidth()) {
            for (int _y = this.rectItems[_idx].y; _y < this.rectItems[_idx].y + this.rectItems[_idx].height; _y += this._sprButton.getHeight()) {
                this._sprButton.setFrame(this.getWindowTileSprite(_iTileX, _iTileY, _cols, _rows));
                this._sprButton.setPosition(_x, _y);
                this._sprButton.paint(g);
                ++_iTileY;
            }
            _iTileY = 0;
            ++_iTileX;
        }
        g.drawImage(_imgIcon, this.rectItems[_idx].getCenterX(), this.rectItems[_idx].getCenterY(), 3);
    }

    private void paintMenuCharacter(Graphics g) {
        g.drawImage(this._imgCharacterBird, this.rectItems[7].getCenterX(), this.rectItems[7].getCenterY(), 3);
        g.drawImage(this._imgCharacterFrog, this.rectItems[8].getCenterX(), this.rectItems[8].getCenterY(), 3);
        g.drawImage(this._imgCharacterMole, this.rectItems[9].getCenterX(), this.rectItems[9].getCenterY(), 3);
        g.drawImage(this._imgCharacterPig, this.rectItems[10].getCenterX(), this.rectItems[10].getCenterY(), 3);
        g.drawImage(this._imgCharacterPlatypus, this.rectItems[11].getCenterX(), this.rectItems[11].getCenterY(), 3);
        g.drawImage(this._imgCharacterTurtle, this.rectItems[12].getCenterX(), this.rectItems[12].getCenterY(), 3);
    }

    private void paintMenuCharacterCheckBoxes(Graphics g) {
        this.paintCheckBox(g, 7);
        this.paintCheckBox(g, 8);
        this.paintCheckBox(g, 9);
        this.paintCheckBox(g, 10);
        this.paintCheckBox(g, 11);
        this.paintCheckBox(g, 12);
        int _iOffsetX = this._sprCheckBox.getWidth() >> 1;
        int _iOffsetY = this._sprCheckBox.getHeight() >> 1;
        if (this._iUnlockedCharacters[this.selectedCharacterId - 7] == 1) {
            g.drawImage(this._imgIconYes, this.rectItems[this.selectedCharacterId].getCenterX() + this._sprCheckBox.getWidth() + _iOffsetX, this.rectItems[this.selectedCharacterId].getCenterY() - (this._sprCheckBox.getWidth() >> 1) + _iOffsetY, 3);
        }
    }

    private void paintCheckBox(Graphics g, int _idx) {
        int _iTmpId = _idx - 7;
        if (this._iUnlockedCharacters[_iTmpId] == 1) {
            this._sprCheckBox.setFrame(0);
            this._sprCheckBox.setPosition(this.rectItems[_idx].getCenterX() + this._sprCheckBox.getWidth(), this.rectItems[_idx].getCenterY() - (this._sprCheckBox.getWidth() >> 1));
            this._sprCheckBox.paint(g);
        } else {
            Rectangle _rect = new Rectangle(this.rectItems[_idx].getCenterX() + this._sprCheckBox.getWidth(), this.rectItems[_idx].getCenterY() - (this._sprCheckBox.getWidth() >> 1), this._sprButton.getWidth() * 5, this._sprButton.getHeight() * 3);
            int _iTileX = 0;
            int _iTileY = 0;
            for (int _x = _rect.x; _x < _rect.x + _rect.width; _x += this._sprButton.getWidth()) {
                for (int _y = _rect.y; _y < _rect.y + _rect.height; _y += this._sprButton.getHeight()) {
                    this._sprButton.setFrame(this.getWindowTileSprite(_iTileX, _iTileY, 5, 3));
                    this._sprButton.setPosition(_x, _y);
                    this._sprButton.paint(g);
                    ++_iTileY;
                }
                _iTileY = 0;
                ++_iTileX;
            }
            this._ptCost.prepareText("" + this._iCharactersCost[_iTmpId], _rect.width);
            this._ptCost.drawText(g, _rect, 0, 3);
        }
    }

    private void paintMainMenuSelector(Graphics g) {
        this._sprSelector.setFrame(0);
        for (int _iDx = 0; _iDx < this.rectItems.length; ++_iDx) {
            if (_iDx != this.selectorCompId) continue;
            this._sprSelector.setPosition(this.rectItems[_iDx].getCenterX(), this.rectItems[_iDx].getCenterY());
            this._sprSelector.paint(g);
            return;
        }
    }

    private void paintMenuScore(Graphics g) {
        this._ptTopScore.prepareText("TOP: " + this._iBestScoreSave, this.rectTopScore.width);
        this._ptTopScore.drawText(g, this.rectTopScore, 0, 3);
    }

    private void paintMenuCoins(Graphics g) {
        this._sprCoin.setPosition(this.rectTopCoins.x + (this._sprCoin.getWidth() >> 1), this.rectTopCoins.getCenterY() - (this._sprCoin.getHeight() >> 1));
        this._sprCoin.paint(g);
        this._ptTopCoins.prepareText(": " + this._iCoins, this.rectTopCoins.width);
        this._ptTopCoins.drawText(g, this.rectTopCoins, 0, 3);
    }

    private void paintOptionsWindow(Graphics g) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int x = this.rectWindow.x; x < this.rectWindow.x + this.rectWindow.width; x += this._sprWindow.getWidth()) {
            for (int y = this.rectWindow.y; y < this.rectWindow.y + this.rectWindow.height; y += this._sprWindow.getHeight()) {
                this._sprWindow.setFrame(this.getWindowTileSprite(_actualTileX, _actualTileY, this._iTotalColWindowsTile, this._iTotalRowWindowsTile));
                this._sprWindow.setPosition(x, y);
                this._sprWindow.paint(g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
        this.paintOptionsItems(g);
    }

    private void paintOptionsItems(Graphics g) {
        this.paintOptionsButtons(g, 1, false);
        this.menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this.rectItems[1].width);
        this.menuItem.drawText(g, this.rectItems[1], 0, 3);
        this.paintOptionsButtons(g, 3, false);
        this.menuItem.prepareText(Resources.resTexts[0].getHashedString(23), this.rectItems[1].width);
        this.menuItem.drawText(g, this.rectItems[3], 0, 3);
        this.paintOptionsButtons(g, 2, true);
        this.menuItem.prepareText(Resources.resTexts[0].getHashedString(28) + " " + (MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27)), this.rectItems[2].width);
        this.menuItem.drawText(g, this.rectItems[2], 0, 3);
        this.paintOptionsSelector(g);
    }

    private void paintOptionsButtons(Graphics g, int _item, boolean music) {
        int _iTileX = 0;
        int _iTileY = 0;
        _totalColTiles = this._iTotalColButtonTile;
        _totalRowTiles = this._iTotalRowButtonTile;
        for (int _x = this.rectItems[_item].x; _x < this.rectItems[_item].x + this.rectItems[_item].width; _x += this._sprButton.getWidth()) {
            for (int _y = this.rectItems[_item].y; _y < this.rectItems[_item].y + this.rectItems[_item].height; _y += this._sprButton.getHeight()) {
                this._sprButton.setFrame(this.getWindowTileSprite(_iTileX, _iTileY, _totalColTiles, _totalRowTiles));
                this._sprButton.setPosition(_x, _y);
                this._sprButton.paint(g);
                ++_iTileY;
            }
            _iTileY = 0;
            ++_iTileX;
        }
    }

    private void paintOptionsSelector(Graphics g) {
        this._sprSelector.setFrame(0);
        for (int _iDx = 0; _iDx < this.rectItems.length; ++_iDx) {
            if (_iDx != this.selectorCompId) continue;
            this._sprSelector.setPosition(this.rectItems[_iDx].getCenterX(), this.rectItems[_iDx].getCenterY());
            this._sprSelector.paint(g);
            return;
        }
    }

    private void paintInstrusctionTxt(Graphics g) {
        this.instruction.drawText(g, this.rectText, this._iTextOffsetY, 20);
    }

    private void paintArrows(Graphics g) {
        if (this.instruction.getTextHeight() < this.rectText.height) {
            return;
        }
        if (this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y - (this._sprArrows.getHeight() << 1));
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y + this.rectPanel.height + this._sprArrows.getHeight());
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y - (this._sprArrows.getHeight() << 1));
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
        } else if (this.scrollDOWN && !this.scrollUP) {
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y + this.rectPanel.height + this._sprArrows.getHeight());
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        }
    }

    private void paintAboutLogo(Graphics g) {
        g.drawImage(this._imgCorpLogo, this.rectPanel.getCenterX(), this.rectPanel.getCenterY(), 3);
        this.versionOfGame.drawText(g, this.rectPanel, (this._sprButton.getHeight() >> 1) + (this._sprButton.getHeight() << 1), 33);
    }

    private void paintQuit(Graphics g) {
        this.menuItem.prepareText(Resources.resTexts[0].getHashedString(2), this.rectPanel.width);
        this.menuItem.drawText(g, this.rectPanel, 0, 3);
    }

    private void paintFK(Graphics g) {
        if (this.actualSceen == 4) {
            this._sprCheckBox.setPosition(this.rectItems[14].x + this._sprCheckBox.getWidth(), this.rectItems[14].y + this._sprCheckBox.getHeight());
            this._sprCheckBox.paint(g);
            g.drawImage(this._imgIconNo, this._sprCheckBox.getX() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), this._sprCheckBox.getY() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), 20);
            this._sprCheckBox.setPosition(this.rectItems[13].x, this.rectItems[13].y + this._sprCheckBox.getHeight());
            this._sprCheckBox.paint(g);
            g.drawImage(this._imgIconYes, this._sprCheckBox.getX() + this._sprCheckBox.getWidth() - (this._imgIconNo.getWidth() >> 1), this._sprCheckBox.getY() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), 24);
        } else if (this.actualSceen != 0) {
            this._sprCheckBox.setPosition(this.rectItems[14].x + this._sprCheckBox.getWidth(), this.rectItems[14].y + this._sprCheckBox.getHeight());
            this._sprCheckBox.paint(g);
            g.drawImage(this._imgIconBack, this._sprCheckBox.getX() + (this._imgIconNo.getWidth() >> 1), this._sprCheckBox.getY() + (this._imgIconNo.getWidth() >> 1), 20);
        }
    }

    private void paintTiledWindow(Graphics g) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int x = this.rectPanel.x; x < this.rectPanel.x + this.rectPanel.width; x += this._sprWindow.getWidth()) {
            for (int y = this.rectPanel.y; y < this.rectPanel.y + this.rectPanel.height; y += this._sprWindow.getHeight()) {
                this._sprWindow.setFrame(this.getWindowTileSprite(_actualTileX, _actualTileY, this._iTotalColRectTile, this._iTotalRowRectTile));
                this._sprWindow.setPosition(x, y);
                this._sprWindow.paint(g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private int getWindowTileSprite(int _x, int _y, int totalCols, int totalRows) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < totalCols - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == totalCols - 1) {
            return 2;
        }
        if (_y == totalRows - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < totalRows - 1 && _y > 0) {
            return 3;
        }
        if (_x == totalCols - 1 && _y < totalRows - 1 && _y > 0) {
            return 5;
        }
        if (_y == totalRows - 1 && _x < totalCols - 1 && _x > 0) {
            return 7;
        }
        if (_y == totalRows - 1 && _x == totalCols - 1) {
            return 8;
        }
        return 4;
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (this.activeButton) {
            if (Keys.isFKRightCode(keyCode)) {
                switch (this.actualSceen) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.startAnimation(true, 5);
                        break;
                    }
                    case 2: {
                        this.startAnimation(true, 5);
                        break;
                    }
                    case 5: {
                        this.selectorCompId = 0;
                        this.selectedCompId = 0;
                        this.startAnimation(true, 0);
                        break;
                    }
                    case 4: {
                        this.startAnimation(true, 0);
                    }
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                if (this.actualSceen == 4) {
                    X.quitApp();
                }
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    switch (this.actualSceen) {
                        case 0: {
                            switch (this.selectedCompId) {
                                case 0: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 11;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 7;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 6;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 3);
                                    break;
                                }
                                case 5: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 11;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 7;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 6;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 4);
                                    System.out.println("Yes Quit Game");
                                    break;
                                }
                                case 6: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 11;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 7;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 5);
                                    this.selectedCompId = 1;
                                    break;
                                }
                                case 11: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 9;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 12;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 12;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.buyOrSelectCharacter(11);
                                    break;
                                }
                                case 12: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 10;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 11;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 11;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.buyOrSelectCharacter(12);
                                    break;
                                }
                                case 9: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 7;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 11;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 10;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 10;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.buyOrSelectCharacter(9);
                                    break;
                                }
                                case 10: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 8;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 12;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 9;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 9;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.buyOrSelectCharacter(10);
                                    break;
                                }
                                case 7: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 9;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 8;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 8;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.buyOrSelectCharacter(7);
                                    break;
                                }
                                case 8: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 10;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 7;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 7;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.buyOrSelectCharacter(8);
                                }
                            }
                            break;
                        }
                        case 5: {
                            switch (this.selectedCompId) {
                                case 1: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 1);
                                    break;
                                }
                                case 3: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 2);
                                    break;
                                }
                                case 2: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    if (MainCanvas.soundManager.IsSoundOn()) {
                                        MainCanvas.soundManager.SetSoundOn(false);
                                        MainCanvas.soundManager.Stop();
                                        break;
                                    }
                                    MainCanvas.soundManager.SetSoundOn(true);
                                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                                }
                            }
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                }
                this.selectorCompId = this.selectedCompId;
                this.a = this.selectedCompId;
                this.force = this.selectedCompId;
            }
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (i == 16) {
                this.selectorCompId = this.selectedCompId = 16;
                this.mainCanvas.repaint();
                break;
            }
            if (i == 16) continue;
            System.out.println("Ho preeeeeeeeeeeeeees: " + i + " rectItems.length: " + this.rectItems.length);
            if (this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            System.out.println("preeeeeeeeeeeeeees: " + i + " rectItems.length: " + this.rectItems.length);
            this.sel = i <= 4 ? i : this.sel;
            this.selectedCompId = i;
            this.s = i;
            switch (this.selectedCompId) {
                case 4: {
                    break;
                }
                case 5: {
                    this.selectorCompId = 5;
                    this.a = this.selectedCompId = 5;
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
                case 14: {
                    Keys.keyPressed(-22);
                    break;
                }
                case 15: {
                    Keys.keyPressed(-22);
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    this.a = this.selectedCompId = (this.selectorCompId = i);
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.actualSceen == 1) {
            if (this.instruction.getTextHeight() < this.rectText.height - (this._sprWindow.getHeight() << 1)) {
                return;
            }
            System.out.println("SCROL");
            if (this.posY > y) {
                if (Resources.sysFont) {
                    this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this._iTextOffsetY < 0) {
                    this._iTextOffsetY = 0;
                    this.scrollUP = false;
                    this.scrollDOWN = true;
                }
                this.needRepaint = true;
            } else if (this.posY < y) {
                int maxOffsetY = this.instruction.getTextHeight() - this.rectText.height;
                if (Resources.sysFont) {
                    this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this._iTextOffsetY > maxOffsetY) {
                    this._iTextOffsetY = maxOffsetY;
                    this.scrollUP = true;
                    this.scrollDOWN = false;
                }
                this.needRepaint = true;
            }
        }
        if (this.selectedCompId != 16) {
            if (!this.rectItems[this.selectedCompId].contains(x, y)) {
                switch (this.selectedCompId) {
                    case 4: {
                        break;
                    }
                    case 14: {
                        break;
                    }
                    case 5: {
                        Keys.keyReleased(-22);
                        break;
                    }
                    case 15: {
                        Keys.keyReleased(-22);
                        break;
                    }
                    case 13: {
                        Keys.keyReleased(-22);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this.selectorCompId = this.selectedCompId = 16;
            this.mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.selectedCompId != 16) {
            switch (this.selectedCompId) {
                case 5: {
                    this.activeButton = true;
                    this.selectedCompId = 5;
                    this.keyReleased(-5);
                    Keys.keyReleased(-5);
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                    break;
                }
                case 15: {
                    if (!Keys.isKeyPressed(-22)) break;
                    this.keyReleased(-22);
                    Keys.keyReleased(-22);
                    break;
                }
                case 13: {
                    this.keyReleased(-21);
                    Keys.keyReleased(-21);
                    break;
                }
                case 14: {
                    this.keyReleased(-22);
                    Keys.keyReleased(-22);
                    break;
                }
                case 4: {
                    if (this.actualSceen != 4) break;
                    X.quitApp();
                    break;
                }
                default: {
                    this.activeButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        System.out.println(" actualSceen: " + this.actualSceen);
        this.selectorCompId = this.selectedCompId = 16;
        this.mainCanvas.repaint();
    }

    private void textMove() {
        if (this.instruction.getTextHeight() < this.rectText.height - (this._sprWindow.getHeight() << 1)) {
            return;
        }
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this._iTextOffsetY < 0) {
                this._iTextOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this.instruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this._iTextOffsetY > maxOffsetY) {
                this._iTextOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
    }
}

