/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenSplash;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenLanguage
implements IScreen {
    private MainCanvas mainCanvas;
    private static String[] langCodes = new String[]{"en", "de", "fr", "es", "pt", "it"};
    private Rectangle[] _rectItems = new Rectangle[6];
    private static int _WIDTH = 0;
    private static int _HEIGHT = 0;
    private int[] _animationSequence = new int[6];
    private AnimationComponent[] _animationComponents = new AnimationComponent[6];
    private int _iSelectedCompId;
    private boolean _bChangeScreen = false;
    private Sprite _sprLanguage;
    private Sprite _sprSelector;

    public ScreenLanguage(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
        this.initDimensions();
        this._iSelectedCompId = 0;
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    public void beforeShow() {
        Resources.loadSprites(new int[]{38, 39});
        this.initSprite();
        this.calculatePositions();
    }

    public void afterHide() {
        Resources.freeSprites(new int[]{38, 39});
        this.freeGraphics();
    }

    private void initSprite() {
        this._sprLanguage = Resources.resSprs[38];
        this._sprSelector = Resources.resSprs[39];
    }

    private void freeGraphics() {
        this._sprLanguage = null;
        this._sprSelector = null;
    }

    public void beforeInteruption() {
    }

    public void afterInteruption() {
    }

    private void calculatePositions() {
        int btnWidth = this._sprLanguage.getWidth();
        int btnHeight = this._sprLanguage.getHeight();
        int spaceX = (_WIDTH - btnWidth * 2) / 3;
        int spaceY = (_HEIGHT - btnHeight * 3) / 4;
        for (int i = 0; i < 6; ++i) {
            this._rectItems[i] = new Rectangle(spaceX + i % 2 * (btnWidth + spaceX), spaceY + i / 2 * (btnHeight + spaceY), btnWidth, btnHeight);
        }
        this.showAnimationComponents();
    }

    private void showAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectItems[0], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[0].startShowAnimation(4);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this._rectItems[1], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[1].startShowAnimation(5);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this._rectItems[2], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this._rectItems[3], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this._rectItems[4], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[4].startShowAnimation(6);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this._rectItems[5], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[5].startShowAnimation(7);
    }

    private void hideAnimationComponents() {
        this._animationComponents[0].startHideAnimation(4);
        this._animationComponents[1].startHideAnimation(5);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(6);
        this._animationComponents[5].startHideAnimation(7);
    }

    public void update(long lastRunLenght) {
        this.animationComponentsUpdate();
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (this._bChangeScreen && !_return) {
            this.changeScreen();
        }
    }

    private void hideLanguage() {
        this._bChangeScreen = true;
        this.hideAnimationComponents();
    }

    private void changeScreen() {
        Resources.initLangDirs(langCodes[this._iSelectedCompId]);
        this.mainCanvas.changeLastActiveScreen(new ScreenSplash(this.mainCanvas));
    }

    public void paint(Graphics g) {
        this.paintBackgroundColor(g);
        this.paintFlags(g, MainCanvas.touchActivated);
    }

    private void paintBackgroundColor(Graphics g) {
        g.setColor(11856989);
        g.fillRect(0, 0, _WIDTH, _HEIGHT);
    }

    private void paintFlags(Graphics g, boolean _bPaintSelector) {
        for (int _iIdx = 0; _iIdx < this._rectItems.length; ++_iIdx) {
            this._sprLanguage.setFrame(_iIdx == 5 ? _iIdx + 1 : _iIdx);
            this._sprLanguage.setPosition(this._rectItems[_iIdx].x, this._rectItems[_iIdx].y);
            this._sprLanguage.paint(g);
            if (_bPaintSelector || _iIdx != this._iSelectedCompId) continue;
            this._sprSelector.setFrame(0);
            this._sprSelector.setPosition(this._rectItems[_iIdx].x + (this._sprSelector.getWidth() >> 1), this._rectItems[_iIdx].y + (this._sprSelector.getHeight() >> 1));
            this._sprSelector.paint(g);
        }
    }

    public void keyPressed(int keyCode) {
        this.mainCanvas.repaint();
        System.out.println("keyCode: " + keyCode);
    }

    public void keyReleased(int keyCode) {
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                if (this._iSelectedCompId % 2 == 1) {
                    --this._iSelectedCompId;
                }
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                if (this._iSelectedCompId % 2 == 0) {
                    ++this._iSelectedCompId;
                }
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                if (this._iSelectedCompId / 2 > 0) {
                    this._iSelectedCompId -= 2;
                }
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                if (this._iSelectedCompId != 5 && this._iSelectedCompId != 4 && this._iSelectedCompId / 2 < 3) {
                    this._iSelectedCompId += 2;
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                this.hideLanguage();
            } else if (Keys.isActionGeneratedByKey(-202, keyCode)) {
                Resources.initLangDirs(langCodes[this._iSelectedCompId]);
            } else if (Keys.isActionGeneratedByKey(-203, keyCode)) {
                Resources.initLangDirs(langCodes[this._iSelectedCompId]);
            }
        }
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                default: 
            }
            Keys.keyPressed(53);
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                default: 
            }
            Keys.keyReleased(53);
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this._iSelectedCompId) {
            default: 
        }
        if (Keys.isKeyPressed(53)) {
            this.keyReleased(53);
            Keys.keyReleased(53);
        }
    }
}

